<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MapsPlaces;

class GoogleMapsPlacesV1FuelOptionsFuelPrice extends \Google\Model
{
  /**
   * @var GoogleTypeMoney
   */
  public $price;
  protected $priceType = GoogleTypeMoney::class;
  protected $priceDataType = '';
  /**
   * @var string
   */
  public $type;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param GoogleTypeMoney
   */
  public function setPrice(GoogleTypeMoney $price)
  {
    $this->price = $price;
  }
  /**
   * @return GoogleTypeMoney
   */
  public function getPrice()
  {
    return $this->price;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleMapsPlacesV1FuelOptionsFuelPrice::class, 'Google_Service_MapsPlaces_GoogleMapsPlacesV1FuelOptionsFuelPrice');
