<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3Environment extends \Google\Collection
{
  protected $collection_key = 'versionConfigs';
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var string
   */
  public $name;
  /**
   * @var GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
   */
  public $testCasesConfig;
  protected $testCasesConfigType = GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig::class;
  protected $testCasesConfigDataType = '';
  /**
   * @var string
   */
  public $updateTime;
  /**
   * @var GoogleCloudDialogflowCxV3EnvironmentVersionConfig[]
   */
  public $versionConfigs;
  protected $versionConfigsType = GoogleCloudDialogflowCxV3EnvironmentVersionConfig::class;
  protected $versionConfigsDataType = 'array';
  /**
   * @var GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
   */
  public $webhookConfig;
  protected $webhookConfigType = GoogleCloudDialogflowCxV3EnvironmentWebhookConfig::class;
  protected $webhookConfigDataType = '';

  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
   */
  public function setTestCasesConfig(GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig $testCasesConfig)
  {
    $this->testCasesConfig = $testCasesConfig;
  }
  /**
   * @return GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
   */
  public function getTestCasesConfig()
  {
    return $this->testCasesConfig;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * @param GoogleCloudDialogflowCxV3EnvironmentVersionConfig[]
   */
  public function setVersionConfigs($versionConfigs)
  {
    $this->versionConfigs = $versionConfigs;
  }
  /**
   * @return GoogleCloudDialogflowCxV3EnvironmentVersionConfig[]
   */
  public function getVersionConfigs()
  {
    return $this->versionConfigs;
  }
  /**
   * @param GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
   */
  public function setWebhookConfig(GoogleCloudDialogflowCxV3EnvironmentWebhookConfig $webhookConfig)
  {
    $this->webhookConfig = $webhookConfig;
  }
  /**
   * @return GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
   */
  public function getWebhookConfig()
  {
    return $this->webhookConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3Environment::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Environment');
