<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class OceanDocTagBookSpecific extends \Google\Collection
{
  protected $collection_key = 'numberingrange';
  /**
   * @var string[]
   */
  public $auxBibkeys;
  /**
   * @var string
   */
  public $imprint;
  /**
   * @var int
   */
  public $numRatingHalfStars;
  /**
   * @var OceanDocTagBookSpecificNumberingRange[]
   */
  public $numberingrange;
  protected $numberingrangeType = OceanDocTagBookSpecificNumberingRange::class;
  protected $numberingrangeDataType = 'array';
  /**
   * @var string
   */
  public $partnerId;
  /**
   * @var int
   */
  public $productEditionNumber;
  /**
   * @var string
   */
  public $publicationDate;
  /**
   * @var string
   */
  public $publisherName;
  /**
   * @var string
   */
  public $subject;

  /**
   * @param string[]
   */
  public function setAuxBibkeys($auxBibkeys)
  {
    $this->auxBibkeys = $auxBibkeys;
  }
  /**
   * @return string[]
   */
  public function getAuxBibkeys()
  {
    return $this->auxBibkeys;
  }
  /**
   * @param string
   */
  public function setImprint($imprint)
  {
    $this->imprint = $imprint;
  }
  /**
   * @return string
   */
  public function getImprint()
  {
    return $this->imprint;
  }
  /**
   * @param int
   */
  public function setNumRatingHalfStars($numRatingHalfStars)
  {
    $this->numRatingHalfStars = $numRatingHalfStars;
  }
  /**
   * @return int
   */
  public function getNumRatingHalfStars()
  {
    return $this->numRatingHalfStars;
  }
  /**
   * @param OceanDocTagBookSpecificNumberingRange[]
   */
  public function setNumberingrange($numberingrange)
  {
    $this->numberingrange = $numberingrange;
  }
  /**
   * @return OceanDocTagBookSpecificNumberingRange[]
   */
  public function getNumberingrange()
  {
    return $this->numberingrange;
  }
  /**
   * @param string
   */
  public function setPartnerId($partnerId)
  {
    $this->partnerId = $partnerId;
  }
  /**
   * @return string
   */
  public function getPartnerId()
  {
    return $this->partnerId;
  }
  /**
   * @param int
   */
  public function setProductEditionNumber($productEditionNumber)
  {
    $this->productEditionNumber = $productEditionNumber;
  }
  /**
   * @return int
   */
  public function getProductEditionNumber()
  {
    return $this->productEditionNumber;
  }
  /**
   * @param string
   */
  public function setPublicationDate($publicationDate)
  {
    $this->publicationDate = $publicationDate;
  }
  /**
   * @return string
   */
  public function getPublicationDate()
  {
    return $this->publicationDate;
  }
  /**
   * @param string
   */
  public function setPublisherName($publisherName)
  {
    $this->publisherName = $publisherName;
  }
  /**
   * @return string
   */
  public function getPublisherName()
  {
    return $this->publisherName;
  }
  /**
   * @param string
   */
  public function setSubject($subject)
  {
    $this->subject = $subject;
  }
  /**
   * @return string
   */
  public function getSubject()
  {
    return $this->subject;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OceanDocTagBookSpecific::class, 'Google_Service_Contentwarehouse_OceanDocTagBookSpecific');
