<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class CloudAiPlatformTenantresourceTenantProjectConfig extends \Google\Collection
{
  protected $collection_key = 'services';
  /**
   * @var GoogleApiServiceconsumermanagementV1BillingConfig
   */
  public $billingConfig;
  protected $billingConfigType = GoogleApiServiceconsumermanagementV1BillingConfig::class;
  protected $billingConfigDataType = '';
  /**
   * @var string
   */
  public $folder;
  /**
   * @var GoogleApiServiceconsumermanagementV1PolicyBinding[]
   */
  public $policyBindings;
  protected $policyBindingsType = GoogleApiServiceconsumermanagementV1PolicyBinding::class;
  protected $policyBindingsDataType = 'array';
  /**
   * @var string[]
   */
  public $services;

  /**
   * @param GoogleApiServiceconsumermanagementV1BillingConfig
   */
  public function setBillingConfig(GoogleApiServiceconsumermanagementV1BillingConfig $billingConfig)
  {
    $this->billingConfig = $billingConfig;
  }
  /**
   * @return GoogleApiServiceconsumermanagementV1BillingConfig
   */
  public function getBillingConfig()
  {
    return $this->billingConfig;
  }
  /**
   * @param string
   */
  public function setFolder($folder)
  {
    $this->folder = $folder;
  }
  /**
   * @return string
   */
  public function getFolder()
  {
    return $this->folder;
  }
  /**
   * @param GoogleApiServiceconsumermanagementV1PolicyBinding[]
   */
  public function setPolicyBindings($policyBindings)
  {
    $this->policyBindings = $policyBindings;
  }
  /**
   * @return GoogleApiServiceconsumermanagementV1PolicyBinding[]
   */
  public function getPolicyBindings()
  {
    return $this->policyBindings;
  }
  /**
   * @param string[]
   */
  public function setServices($services)
  {
    $this->services = $services;
  }
  /**
   * @return string[]
   */
  public function getServices()
  {
    return $this->services;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CloudAiPlatformTenantresourceTenantProjectConfig::class, 'Google_Service_Contentwarehouse_CloudAiPlatformTenantresourceTenantProjectConfig');
