<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class QuerySource extends \Google\Collection
{
  protected $collection_key = 'operators';
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var QueryOperator[]
   */
  public $operators;
  protected $operatorsType = QueryOperator::class;
  protected $operatorsDataType = 'array';
  /**
   * @var string
   */
  public $shortName;
  /**
   * @var Source
   */
  public $source;
  protected $sourceType = Source::class;
  protected $sourceDataType = '';

  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param QueryOperator[]
   */
  public function setOperators($operators)
  {
    $this->operators = $operators;
  }
  /**
   * @return QueryOperator[]
   */
  public function getOperators()
  {
    return $this->operators;
  }
  /**
   * @param string
   */
  public function setShortName($shortName)
  {
    $this->shortName = $shortName;
  }
  /**
   * @return string
   */
  public function getShortName()
  {
    return $this->shortName;
  }
  /**
   * @param Source
   */
  public function setSource(Source $source)
  {
    $this->source = $source;
  }
  /**
   * @return Source
   */
  public function getSource()
  {
    return $this->source;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(QuerySource::class, 'Google_Service_CloudSearch_QuerySource');
