<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig extends \Google\Model
{
  /**
   * @var GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public $attributionScoreDriftThresholds;
  protected $attributionScoreDriftThresholdsType = GoogleCloudAiplatformV1ThresholdConfig::class;
  protected $attributionScoreDriftThresholdsDataType = 'map';
  /**
   * @var GoogleCloudAiplatformV1ThresholdConfig
   */
  public $defaultDriftThreshold;
  protected $defaultDriftThresholdType = GoogleCloudAiplatformV1ThresholdConfig::class;
  protected $defaultDriftThresholdDataType = '';
  /**
   * @var GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public $driftThresholds;
  protected $driftThresholdsType = GoogleCloudAiplatformV1ThresholdConfig::class;
  protected $driftThresholdsDataType = 'map';

  /**
   * @param GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public function setAttributionScoreDriftThresholds($attributionScoreDriftThresholds)
  {
    $this->attributionScoreDriftThresholds = $attributionScoreDriftThresholds;
  }
  /**
   * @return GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public function getAttributionScoreDriftThresholds()
  {
    return $this->attributionScoreDriftThresholds;
  }
  /**
   * @param GoogleCloudAiplatformV1ThresholdConfig
   */
  public function setDefaultDriftThreshold(GoogleCloudAiplatformV1ThresholdConfig $defaultDriftThreshold)
  {
    $this->defaultDriftThreshold = $defaultDriftThreshold;
  }
  /**
   * @return GoogleCloudAiplatformV1ThresholdConfig
   */
  public function getDefaultDriftThreshold()
  {
    return $this->defaultDriftThreshold;
  }
  /**
   * @param GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public function setDriftThresholds($driftThresholds)
  {
    $this->driftThresholds = $driftThresholds;
  }
  /**
   * @return GoogleCloudAiplatformV1ThresholdConfig[]
   */
  public function getDriftThresholds()
  {
    return $this->driftThresholds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1ModelMonitoringObjectiveConfigPredictionDriftDetectionConfig');
