<?php
require_once 'vendor/autoload.php';
require_once ('libs/rb.php');
require_once ('libs/db.php');

exit();
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\ConnectException;

define('OPENAI_API_KEY', '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');

set_time_limit(1000);

function getemoji($text, $api_key, $model='gpt-3.5-turbo') {
    try {
        $client = new Client([
            'base_uri' =>  'https://api.openai.com/v1/chat/completions',
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization' => "Bearer {$api_key}"
            ]
        ]);
        
        $prompt = "{$text}";

        $messages = [
            [
                'role' => 'system',
                'content' => 'ChatGPT, you are a Natural Language Understanding expert. You will analyze the sentiment, keywords, and subjects of each question or statement that is made about a person between the ages of 13 and 19 and determine a pool of appropriate emojis to display. You will then display those emojis delimited by a space and return ONLY the emojis and the spaces.'
            ],
            [
                'role' => 'user',
                'content' => $prompt
            ]
        ];
        
        $response = $client->post('', [
            'json' => [
                'model' => $model,
                'messages' => $messages,
                'max_tokens' => 2000,
                'n' => 1,
                'stop' => null,
                'temperature' => 0.0
            ]
        ]);
        
        //$responseData = json_decode($response->getBody(), true);
        //return $responseData['choices'][0]['message']['content'];
        $responseData = json_decode($response->getBody(), true);
        $emojis = explode(' ', trim($responseData['choices'][0]['message']['content']));
        
        // Randomly select one emoji from the array
        if (!empty($emojis)) {
            return $emojis[array_rand($emojis)];
        } else {
            return ''; // Return an empty string if no emojis are found
        }
        
    } catch (\Exception $e) {
        error_log('gpt failed: ' . $e->getMessage());
        return null;
    } catch (RequestException $e) {
       error_log('gpt failed: ' . $e->getMessage());
    } catch (ConnectException $e) {
       error_log('gpt failed: ' . $e->getMessage());
    } 
}

$questions = R::findAll('question', ' id >= 678 ');
try {
    R::begin();
    
    $count = 0;
    foreach ($questions as $question) {
        $emoji = getemoji($question->text, OPENAI_API_KEY); 
        $question->emoji = $emoji;
        $question->updated_at = gmdate('Y-m-d H:i:s');
        R::store($question);
        
        $count = $count + 1;
        if($count > 200) {
            break;
        }
    }
    R::commit();
} catch (\Exception $e) {
    R::rollback();
    error_log('Transaction failed: ' . $e->getMessage());
}

 /*$emoji = getemoji("definitely going to heaven", OPENAI_API_KEY);
 $displayEmoji = "<span style='font-size: 400px;'>$emoji</span>";
 echo $displayEmoji;
*/
?>