<?php
require_once __DIR__ . '/../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');


define('AGGREGATE_NOTIFICATIONS', true);

function processNotificationQueue() {
    global $redis;
    $redis = Database::getRedis(); // Get Redis instance from the Database class
    $batchSize = 1000;
    $count = $redis->lLen('notification_queue');

    while ($count > 0) {
        if (!Database::allowRequest()) {
            echo "Rate limit exceeded, waiting...\n";
            sleep(5);  // Wait before trying again
            continue;  // Skip this iteration and check again
        }
        
        $batchNotifications = $redis->lRange('notification_queue', 0, min($batchSize - 1, $count - 1));
        if (AGGREGATE_NOTIFICATIONS) {
            processBatchNotificationsAggregated($batchNotifications);
        } else {
            processBatchNotifications($batchNotifications);
        }
        $redis->lTrim('notification_queue', count($batchNotifications), -1);
        $count -= count($batchNotifications);
    }
}

function processBatchNotifications($batchNotifications) {
    foreach ($batchNotifications as $jsonNotification) {
        $notification = json_decode($jsonNotification, true);
        sendIndividualNotification($notification);
    }
}

function processBatchNotificationsAggregated($batchNotifications) {
    $notificationSummary = [];

    foreach ($batchNotifications as $jsonNotification) {
        $notification = json_decode($jsonNotification, true);
        $key = "{$notification['user_id']}-{$notification['notification_type']}";

        if (!isset($notificationSummary[$key])) {
            $notificationSummary[$key] = [
                'user_id' => $notification['user_id'],
                'type' => $notification['notification_type'],
                'count' => 0,
                'friend_ids' => []
            ];
        }

        $notificationSummary[$key]['count']++;
        $notificationSummary[$key]['friend_ids'][] = $notification['friend_id'];
    }

    foreach ($notificationSummary as $summary) {
        sendAggregatedNotification($summary);
    }
}

function sendIndividualNotification($notification) {
    $userId = $notification['user_id'];
    $friendId = $notification['friend_id'];
    $type = $notification['notification_type'];

    $user = R::load('user', $userId);
    $friend = R::load('user', $friendId);

    if ($user && $friend && !empty($user->fcmtoken)) {
        list($title, $body) = createNotificationContent($type, $user, $friend, 1);
        sendPushNotification($user->fcmtoken, $title, $body, SERVICES_ACCOUNT);
    }
}

function sendAggregatedNotification($summary) {
    $user = R::load('user', $summary['user_id']);
    $friend = R::load('user', end($summary['friend_ids'])); // Using the last friend's details

    if ($user && $friend && !empty($user->fcmtoken)) {
        list($title, $body) = createNotificationContent($summary['type'], $user, $friend, $summary['count']);
        sendPushNotification($user->fcmtoken, $title, $body, SERVICES_ACCOUNT);
    }
}

function createNotificationContent($type, $user, $friend, $count) {
    switch ($type) {
        case 1: // Like or vote
            $gender = ($friend->gender_id == 1) ? "boy" : "girl";
            $gender = ($friend->gender_id == 3) ? "friend" : $gender; //non-binary
            $emotion = ($user->gender_id != $friend->gender_id) ? "❤️" : "👍";
            $title = ($count > 1) ? "{$count} people voted for you! ❤️" : "A $gender voted for you! $emotion";
            $body = "Tap here to see what they said!";
            break;
        case 2: // Friend added
            $title = ($count > 1) ? "{$count} people added you as a friend! 🙂" : "{$friend->first_name} {$friend->last_name} added you as a friend 🙂";
            $body = "Tap here to vote for them!";
            break;
        case 3: // Poll insert or follower
            $title = "Crush Alert! ❤️";
            $body = ($friend->gender_id == 3) ? "A friend added their name to your poll!" : ($friend->gender_id == 1 ? "A boy added their name to your poll!" : "A girl added their name to your poll!");
            $body = ($count > 1) ? "{$count} people added their name to your poll!" : $body;
            break;
        default:
            $title = "You are missing out on the action!";
            $body = "Tap to see who likes you!";
            break;
    }
    return [$title, $body];
}


processNotificationQueue();

/*
function processNotificationQueue() {
    $batchSize = 1000;
    $unprocessedNotifications = R::find('pushnotificationqueue', 'processed = ?', [false]);
    $totalNotifications = count($unprocessedNotifications);

    // Process notifications in batches of 1000
    for ($i = 0; $i < $totalNotifications; $i += $batchSize) {
        $batchNotifications = array_slice($unprocessedNotifications, $i, $batchSize);
        processBatchNotifications($batchNotifications);
    }
}

function processBatchNotifications($batchNotifications) {
    $notificationDetails = [];
    foreach ($batchNotifications as $notification) {
        $key = $notification->user_id . '-' . $notification->notification_type;
        $notificationDetails[$key]['count'] = ($notificationDetails[$key]['count'] ?? 0) + 1;
        $notificationDetails[$key]['friend_id'] = $notification->friend_id;
    }

    foreach ($notificationDetails as $key => $details) {
        list($userId, $type) = explode('-', $key);
        $user = R::load('user', $userId);
        $friendId = $details['friend_id'];

        // Fetch friend information
        $friend = R::load('user', $friendId);

        if ($user && $friend && !empty($user->fcmtoken)) {
            // Customize message based on type and gender
            switch ($type) {
                case 1: // Like or vote
                    $gender = ($friend->gender_id == 1) ? "boy" : "girl";
                    $gender = ($friend->gender_id == 3) ? "friend" : $gender; //non-binary
                    $emotion = ($user->gender_id != $friend->gender_id) ? "❤️" : "👍";
                    $title = ($details['count'] > 1) ? "{$details['count']} people voted for you! ❤️" : "A $gender voted for you! $emotion";
                    $body = "Tap here to see what they said!";
                    break;
                case 2: // Friend added
                    $title = ($details['count'] > 1) ? "{$details['count']} people added you as a friend! 🙂" : "$friend->first_name $friend->last_name added you as a friend 🙂";
                    $body = "Tap here to vote for them!";
                    break;
                case 3: // Poll insert or follower
                    $body = ($friend->gender_id == 3) ? "A friend added their name to your poll!" : ($friend->gender_id == 1 ? "A boy added their name to your poll!" : "A girl added their name to your poll!");
                    $title = ($details['count'] > 1) ? "Crush Alert! ❤️ x {$details['count']}" : "Crush Alert! ❤️";
                    $body = ($details['count'] > 1) ? "{$details['count']} people added their name to your poll!" : $body;
                    break;
                default:
                    $title = "You are missing out on the action!";
                    $body = "Tap to see who likes you!";
                    break;
            }

            if (!sendPushNotification($user->fcmtoken, $title, $body, SERVICES_ACCOUNT)) {
                sleep($backOff);
                $backOff *= 2; // Increase backoff time for the next notification in case of failure
            } else {
                $backOff = 1; // Reset backoff on successful send
                R::exec("UPDATE pushnotificationqueue SET processed = ? WHERE user_id = ? AND notification_type = ? AND processed = ?", [1, $userId, $type, 0]);
            }
            
        }
    }
}

processNotificationQueue();*/



?>