<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class username {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($username, $firstname, $lastname) {
    try {
        $firebaseuserid = BasicAuth::getfirebaseuserid();
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();

        if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }

        if (!$username) {
            throw new RestException(400, 'Error: username is required.');
        }

        if (!$firstname) {
            throw new RestException(400, 'Error: first name is required.');
        }

        if (!$lastname) {
            throw new RestException(400, 'Error: last name is required.');
        }

        try {
            $existingUser = R::findOne('user', 'username = ?', [$username]);

            if ($existingUser) {
                $retobj = new stdClass();
                $retobj->success = false;
                $retobj->message = "Username is already taken, please try a different one.";
                return $retobj;
            } else {
                $user->username = $username;
                $user->first_name = $firstname;
                $user->last_name = $lastname;
                R::store($user); // Save the changes

                $retobj = new stdClass();
                $retobj->success = true;
                $retobj->message = "User details updated successfully.";
                return $retobj;
            }
        } catch (Exception $e) {
            // Log the error when checking for an existing username or saving changes
            AppLogger::logError("[username]: Error updating user details: " . $e->getMessage(), [
                'userid' => $userid,
                'firebaseuserid' => $firebaseuserid,
                'username' => $username
            ]);
            throw new RestException(500, "An error occurred while updating user details.");
        }
    } catch (Exception $e) {
        // General catch block for other unexpected errors
        AppLogger::logError("[username]: General error in post method: " . $e->getMessage(), [
            'userid' => $userid,
            'firebaseuserid' => $firebaseuserid
        ]);
        throw new RestException(500, "An error occurred while processing the request.");
    }
}

    /*protected function post($username, $firstname, $lastname) {
        $firebaseuserid = BasicAuth::getfirebaseuserid();
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
    
        if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }
    
        if (!$username) {
            throw new RestException(400, 'Error: username is required.');
        }
        
        if (!$firstname) {
            throw new RestException(400, 'Error: first name is required.');
        }
        
        if (!$lastname) {
            throw new RestException(400, 'Error: last name is required.');
        }
        
        $existingUser = R::findOne('user', 'username = ?', [$username]);
        
        if ($existingUser) {
            // Username is taken
            $retobj = new stdClass();
            $retobj->success = false;
            $retobj->message = "Username is already taken, please try a different one.";
            return $retobj;
        } else {
            $user->username = $username;
            $user->first_name = $firstname;
            $user->last_name = $lastname;
            R::store($user); // Save the changes
            
            $retobj = new stdClass();
            $retobj->success = true;
            $retobj->message = "Username updated successfully.";
            return $retobj;
        }
    }*/
    
    function get($firstname, $lastname) {
       $firebaseuserid = BasicAuth::getfirebaseuserid();
       $userid = BasicAuth::getuserid();
       $user = BasicAuth::getuser();
    
        /*if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }*/
    
        
        if (!$firstname) {
            throw new RestException(400, 'Error: first name is required.');
        }
        
        if (!$lastname) {
            throw new RestException(400, 'Error: last name is required.');
        }
        
        $username = strtolower($firstname) . strtolower($lastname) . rand(1000, 9999);
        
        return $username;
        
        
    }
}
?>