<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class createaccount {
    //public $db;
    function __construct() {

    }
    protected function delete($firebaseuserid) {
       if (!$firebaseuserid) {
        throw new RestException(400, 'Error: Firebaseuserid is required to delete an account.');
        }
    
        $retobj = new stdClass();
        
        try {
            $user = R::findOne('user', 'firebaseuserid = ?', [$firebaseuserid]);
    
            if ($user) {
                R::trash($user);
                $retobj->status = "success";
                $retobj->firebaseuserid = $user->firebaseuserid;
            } else {
                $retobj->error = "Error finding user record";
                $retobj->status = "fail";
                AppLogger::logError("[createaccount]: Error finding user record: ", ['firebaseuserid' => $firebaseuserid, 'action' => 'delete']);

            }
        } catch (Exception $e) {
            $retobj->error = "Error deleting user record: " . $e->getMessage();
            $retobj->status = "fail";
            AppLogger::logError("[createaccount]: Error deleting user record: " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid, 'action' => 'delete']);
        }
    
        return $retobj;
    }
        
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
	function post($firebaseuserid, $phonenumber, $grade, $schoolid, $age, $classyear="1979"){
	    
		 if (!$firebaseuserid) {
			throw new RestException(400, 'Error: Firebaseuserid is required to create an account.');
		}
		
		if (!$phonenumber) {
			throw new RestException(400, 'Error: Phone number is required to create an account.');
		}
		
		if (!$grade) {
			throw new RestException(400, 'Error: Grade is required to create an account.');
		}
		
		if (!$schoolid) {
			throw new RestException(400, 'Error: School is required to create an account.');
		}
		
		if (!$age) {
			throw new RestException(400, 'Error: Age is required to create an account.');
		}

    	$retobj = new stdClass();
        try {
            // First, try to find an existing user with the given firebaseuserid
            $existingUser = R::findOne('user', 'firebaseuserid = ?', [$firebaseuserid]);
        
            if (!$existingUser) {
                // No existing user found, so create a new one
                $user = R::dispense('user');
                $user->firebaseuserid = $firebaseuserid;
                $user->phone_number = $phonenumber;
                $user->school_id = $schoolid;
                $user->grade = $grade;
                $user->initial_grade = $grade;
                $user->grade_entry_date = gmdate('Y-m-d');
                $user->expected_graduation_year = $classyear;
                $user->age = $age;
                //$user->api_token = generateUUIDv4();
                $userid = R::store($user);
                $retobj->userid = $userid;
                
                $retobj->new_user = true;
            } else {
                $user = $existingUser;
                $user->phone_number = $phonenumber;
                $user->school_id = $schoolid;
                $user->grade = $grade;
                $user->initial_grade = $grade;
                $user->grade_entry_date = gmdate('Y-m-d');
                $user->expected_graduation_year = $classyear;
                $user->age = $age;
                $userid = R::store($user);
                $retobj->userid = $userid;
                $retobj->new_user = false;
            }
        
            // Populate return object with user information
            $retobj->firebaseuserid = $user->firebaseuserid;
            $retobj->phone_number = $user->phone_number;
            $retobj->api_token = $user->api_token;
            
        } catch (Exception $e) {
            AppLogger::logError("[createaccount]: Error could not create new account: " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid, 'action' => 'create']);
            
            throw new RestException(400, 'Error: Could not create new account: '. $e->getMessage());
        }
        
        return $retobj;
    }
	
    
	protected function get() {
		
		throw new RestException(501, 'GET not implemented');
	}
    
}
?>