<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');


class contact {
    //public $db;
    function __construct() {

    }
    
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
   protected function post($contacts) {
    $userid = BasicAuth::getuserid();
    $user = BasicAuth::getuser();
    $firebaseuserid = BasicAuth::getfirebaseuserid();

    if (!$user) {
        throw new RestException(400, 'Error: User account not found.');
    }
    
     $preSignedUrls = [];
    $existingContacts = R::count('contact', 'user_id = ?', [$userid]);
    if ($existingContacts > 0) {
        return [
            'success' => true,
            'preSignedUrls' => $preSignedUrls,
            'message' => "User already has contacts. No new contacts were added."
        ];
    }
    

    $successCount = 0;
    $failures = [];
   

    foreach ($contacts as $index => $c) {
        try {
            // Insert into Contact table
            $contactBean = R::dispense('contact');
            
            if (!empty($c['unique_id'])) {
                $uniqueId = $c['unique_id'];
                $photoFileName = $uniqueId . '_contact_profile_photo.jpg'; 

                $metadata = [];
                $preSignedUrl = generateUploadPresignedURL(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $photoFileName, "+20 minutes", $metadata);
               
                $preSignedUrls[$uniqueId] = $preSignedUrl;
                $contactBean->photo_url = $photoFileName;
            }
            
            
            $contactBean->first_name = $c['first_name'];
            $contactBean->last_name = $c['last_name'];
            $contactBean->user_id = $userid; 
            $contactBean->created_at = gmdate('Y-m-d H:i:s');
            $contactBean->updated_at = gmdate('Y-m-d H:i:s');
            $contactId = R::store($contactBean);
            
            // Insert phone numbers
            foreach ($c['phone_numbers'] as $phone) {
                $phoneBean = R::dispense('contactphonenumber');
                $phoneBean->type = $phone['type'];
                $phoneBean->number = $phone['number'];
                $phoneBean->contact_id = $contactId;
                $phoneBean->created_at = gmdate('Y-m-d H:i:s');
                $phoneBean->updated_at = gmdate('Y-m-d H:i:s');
                R::store($phoneBean);
            }

            // Insert emails
            foreach ($c['emails'] as $email) {
                $emailBean = R::dispense('contactemail');
                $emailBean->email = $email['email'];
                $emailBean->contact_id = $contactId;
                $emailBean->created_at = gmdate('Y-m-d H:i:s');
                $emailBean->updated_at = gmdate('Y-m-d H:i:s');
                R::store($emailBean);
            }

            $successCount++;
        } catch (Exception $e) {
    
            AppLogger::logError("[contact]: Error importing contacts: " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid]);
            
            $failures[] = [
                'contactIndex' => $index,
                'errorMessage' => $e->getMessage()
            ];
        }
    }

    return [
        'success' => true,
        'preSignedUrls' => $preSignedUrls,
        'message' => "Contacts processed. Successes: $successCount, Failures: " . count($failures),
        'failures' => $failures
    ];
}

    
    function get() {
    	
    	$userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
            
    	$retobj = new stdClass();
    	$retobj->test = "test";
    		
          
        return $retobj;
    }
}
?>