<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class user {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
        function calculateClassYear($grade) {
            // Get the current year and month
            $currentYear = date("Y");
            $currentMonth = date("n"); // "n" returns the month without leading zeros (1 through 12)
        
            // Determine the academic year's start
            // If current month is June or later, the academic year would be considered as started
            if ($currentMonth >= 6) {
                // Current academic year has started, so we count from this year
                $academicYearStart = $currentYear;
            } else {
                // Current academic year hasn't started, it will start this June
                $academicYearStart = $currentYear - 1;
            }
        
            // Calculate how many years until the student is in 12th grade
            $yearsUntilGraduation = 12 - $grade;
        
            // Calculate the graduation year
            $graduationYear = $academicYearStart + $yearsUntilGraduation;
        
            return $graduationYear;
        }
    
    protected function put($firstname=null, $lastname=null, $username=null, $gender_id=null, $school_id=null, $grade=null, $reduce_notifications=null, $hide_top_stars=null, $take_break=null, $poll_visibility_id=null, $photoname=null) {
		$user = BasicAuth::getuser();
       
        if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }
        
        $retobj = new stdClass();
       	
       	//probably don't need to delete existing photo because
       	//new one will have the same name so it will be overwritten
       	if (!empty($user->photo_url) && $photoname != null) {
            try {
                deleteObjectFromR2(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $user->photo_url);
            } catch (Exception $e) {
                 AppLogger::logError("[user]: Error deleting existing photo: " . $e->getMessage(), [
                'userid' => $user->id
            ]);
                $retobj->deletionError = "Error deleting existing photo: " . $e->getMessage();
            }
        }
        
        
        
        if ($photoname) {
            try {
                $user->resource_token = generateUUIDv4();
                $photoname = $user->resource_token . "_profile_photo.jpg";
                $metadata = [];
                $preSignedUrl = generateUploadPresignedURL(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $photoname, "+20 minutes", $metadata);
            
                $user->photo_url = $photoname;
                $retobj->presignedurl = $preSignedUrl;
            } catch (Exception $e) {
                $retobj->error = "Error generating presigned url: " . $e->getMessage();
                $retobj->status = "fail";
                AppLogger::logError("[user]: Error generating presigned url: " . $e->getMessage(), [
                    'userid' => $user->id
                ]);
            }
        }
        
         try {
            if($firstname){
                $user->first_name = $firstname;
            }
            
            if($lastname){
                $user->last_name = $lastname;
            }
            
            if($username){
                $user->username = $username;
            }
            
            if($gender_id){
                $user->gender_id = $gender_id;
            }
            
            if($school_id){
                $user->school_id = $school_id;
            }
            
            if($grade){
                $user->grade = $grade;
                $user->expected_graduation_year = $this->calculateClassYear($grade);
            }
            
            if($reduce_notifications!=null){
                $user->reduce_notifications = $reduce_notifications;
            }
            
            if($hide_top_stars!=null){
                $user->hide_top_stars = $hide_top_stars;
            }
            
            if($take_break!=null){
                $user->take_break = $take_break;
            }
            
            if($poll_visibility_id){
                $user->poll_visibility_id = $poll_visibility_id;
            }
            
            $id = R::store($user);
             $retobj->id = $user->id;
    		$retobj->username = $user->username;
    		$retobj->first_name = $user->first_name;
    		$retobj->last_name = $user->last_name;
    		$retobj->grade = $user->grade;
    		$retobj->school_id = $user->school_id;
    		$retobj->photo_url = $user->photo_url;
    		$retobj->gender_id = $user->gender_id;
    		$retobj->gender_slang = $user->gender->slangdisplay;
    		$retobj->friends_count = R::count('friendship', ' user_id = ? ', [$user->id]);
    		$retobj->coins = $user->coins;
    		$retobj->resource_token = $user->resource_token;
    		
    		$retobj->top_stars = $this->getTopStars($user->id);
    		
    		
    		$total_stars = R::getCell('SELECT SUM(response_count) FROM responsecount WHERE friend_id = ?', [$user->id]);
            $total_stars = $total_stars ?: 0;
             $retobj->star_count = (string)$total_stars;
            
            $retobj->reduce_notifications = $user->reduce_notifications;
           $retobj->hide_top_stars = $user->hide_top_stars;
           $retobj->take_break = $user->take_break;
           $retobj->poll_visibility_id = $user->poll_visibility_id;
    		
    		 $school = R::findOne('school', ' id = ? ', [$user->school_id]);
            if ($school) {
                $retobj->school_abbrev = $school->abbrev;
    		    $retobj->school_name = $school->name;
            }
            $retobj->api_token = $user->api_token;
            $retobj->resource_token = $user->resource_token;
            $retobj->status = "success";
        } catch (Exception $e) {
            $retobj->error = "Error updating user record: " . $e->getMessage();
            $retobj->status = "fail";
            AppLogger::logError("[user]: Error updating user record: " . $e->getMessage(), [
                        'userid' => $user->id
            ]);
        }

        return $retobj;
    }
    
    protected function post($target_userid, $action = "block"){
          $user = BasicAuth::getuser();
        
         if (!$user) {
            throw new RestException(400, 'Error: User not found');
         }
         
         if (!$target_userid) {
            throw new RestException(400, 'Error: Must supply target userid');
         }
         
         
     	$retobj = new stdClass();
     	
     	try{
         	if($action == "block"){
         	    $block = R::findOne('block', ' user_id = ? AND blocked_user_id = ? ', [$user->id, $target_userid]);
         	    if(!$block){
         	        $block = R::dispense('block');
             	    $block->user_id = $user->id;
             	    $block->blocked_user_id = $target_userid;
             	    R::store($block);
             	    
             	    $retobj->status = "success";
             	    $retobj->message = "Blocked user successfully";
         	    }
         	    else{
         	        $retobj->status = "success";
             	    $retobj->message = "User was already blocked";
         	    }
         	}
         	else if($action == "report"){
         	    $report = R::findOne('report', ' user_id = ? AND reported_user_id = ? ', [$user->id, $target_userid]);

         	    if(!$report){
         	        $report = R::dispense('report');
             	    $report->user_id = $user->id;
             	    $report->reported_user_id = $target_userid;
             	    R::store($report);
             	    
             	    $retobj->status = "success";
             	    $retobj->message = "Reported user successfully";
         	    }
         	    else {
         	        $retobj->status = "success";
             	    $retobj->message = "User was already reported";
         	    }
         	}
     	}catch(Exception $e){
     	    return ['status' => 'error', 'message' => "Failed to block or report user: " . $e->getMessage()];
     	}
     	
     	return $retobj;
    }
    
    function getTopStars($userid){
        $sql = "SELECT 
            q.text AS question,
            q.emoji AS emoji,
            rc.response_count AS count
        FROM 
            responsecount rc
        JOIN 
            question q ON rc.question_id = q.id
        WHERE 
            rc.friend_id = :friendId
        ORDER BY 
            rc.response_count DESC LIMIT 3";
            
        return R::getAll($sql, ['friendId' => $userid]);
    }
    
   protected function get($target_userid){
        $user = BasicAuth::getuser();
        if (!$user) {
            throw new RestException(400, 'Error: User not found');
        }
        
        AppLogger::logError("[user]: Error updating user record: ", [
                        'target_userid' => $target_userid
            ]);
            
        if (!$target_userid) {
            //throw new RestException(400, 'Error: Target user not supplied');
            $target_userid = $user->id;
        }
        
         AppLogger::logError("[user]: Error updating user record: ", [
                        'target_userid' => $target_userid
            ]);
            
        $target_user = R::load('user', $target_userid);
        if($target_user->id){
            $retobj = new stdClass();
            $retobj->id = $target_user->id;
    		$retobj->username = $target_user->username;
    		$retobj->first_name = $target_user->first_name;
    		$retobj->last_name = $target_user->last_name;
    		$retobj->grade = $target_user->grade;
    		$retobj->school_id = $target_user->school_id;
    		$retobj->photo_url = $target_user->photo_url;
    		$retobj->gender_id = $target_user->gender_id;
    		$retobj->gender_slang = $target_user->gender->slangdisplay;
    		$retobj->friends_count = R::count('friendship', ' user_id = ? ', [$target_user->id]);
    		$retobj->coins = $target_user->coins;
    		$retobj->api_token = $target_user->api_token;
    		$retobj->resource_token = $target_user->resource_token;
    		
    		$retobj->top_stars = $this->getTopStars($target_userid);
    		
    		
    		$total_stars = R::getCell('SELECT SUM(response_count) FROM responsecount WHERE friend_id = ?', [$target_user->id]);
            $total_stars = $total_stars ?: 0;
            $retobj->star_count = (string)$total_stars;
            
            $retobj->reduce_notifications = $target_user->reduce_notifications;
           $retobj->hide_top_stars = $target_user->hide_top_stars;
           $retobj->take_break = $target_user->take_break;
           $retobj->poll_visibility_id = $target_user->poll_visibility_id;
    		
    		 $school = R::findOne('school', ' id = ? ', [$target_user->school_id]);
            if ($school) {
                $retobj->school_abbrev = $school->abbrev;
    		    $retobj->school_name = $school->name;
            }
        }
        else {
            throw new RestException(404, 'Target user not found');
        }
		
		return $retobj;
    }
   
    /*function get() {
    	
    	$userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
        	$retobj = new stdClass();
       
        
          $metadata = [];
        $preSignedUrl = generateUploadPresignedURL(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, "toto.jpg", "+20 minutes", $metadata);
        
        $retobj->url =  $preSignedUrl;
        
        //$filePath = '/home/cubeso5/yaaas.cubesol.com/profile_images/22_profilephoto.jpg';
        //$keyName = basename($filePath);
        
        try {
           // $result = $s3->putObject([
             //   'Bucket' => 'yaaas-profile-images', 
              //  'Key'    => $keyName,
        //        'Body'   => fopen($filePath, 'r'),
         //   ]);
        
           // $original = $result['ObjectURL'];
        //    $retobj->url =  $original;
            
            
        } catch (AwsException $e) {
            // Uncomment to output error messages: echo "Error: " . $e->getMessage() . PHP_EOL;
        }

    
    	$retobj->test = "test";
    		
          
        return $retobj;
    }*/
}
?>