<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');


class updateprofile {
    //public $db;
    function __construct() {

    }
    
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($gender, $photoname = null){
        $userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		$firebaseuserid = BasicAuth::getfirebaseuserid();
		$apitoken = BasicAuth::getapitoken();
       
        if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }
        
        if (!$firebaseuserid) {
            throw new RestException(400, 'Error: firebaseuserid must be supplied.');
        }
        
        if (!$gender) {
            throw new RestException(400, 'Error: Gender must be supplied.');
        }
    
    
       	$retobj = new stdClass();
       	
       	$user->gender_id = $gender;
       	
       	if (!empty($user->photo_url) && $photoname != null) {
            try {
                // Assuming deleteObjectFromR2 is the function you have for deletion
                deleteObjectFromR2(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $user->photo_url);
            } catch (Exception $e) {
                 AppLogger::logError("[updateprofile]: Error deleting existing photo: " . $e->getMessage(), [
                'userid' => $userid,
                'firebaseuserid' => $firebaseuserid
            ]);
                $retobj->deletionError = "Error deleting existing photo: " . $e->getMessage();
            }
        }
        
            if ($photoname) {
                try {
                    $photoname = $user->resource_token . "_profile_photo.jpg";
                    $metadata = [];
                    $preSignedUrl = generateUploadPresignedURL(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $photoname, "+20 minutes", $metadata);
                
                    $user->photo_url = $photoname;
                    $retobj->presignedurl = $preSignedUrl;
                    
                } catch (Exception $e) {
                    $retobj->error = "Error generating presigned url: " . $e->getMessage();
                    $retobj->status = "fail";
                    AppLogger::logError("[updateprofile]: Error generating presigned url: " . $e->getMessage(), [
                        'userid' => $userid,
                        'firebaseuserid' => $firebaseuserid
                    ]);
                }
            }

		 try {
            $id = R::store($user);
            $retobj->userid = $user->id;
            $retobj->gender_id = $user->gender_id;
            $retobj->status = "success";
        } catch (Exception $e) {
            $retobj->error = "Error updating user record: " . $e->getMessage();
            $retobj->status = "fail";
            AppLogger::logError("[updateprofile]: Error updating user record: " . $e->getMessage(), [
                        'userid' => $userid,
                        'firebaseuserid' => $firebaseuserid
                    ]);
        }

    return $retobj;
	
		
			/*if($photoname != null){
       	$provider = CredentialProvider::ini(null, '/home/cubeso5/.aws/credentials');
    $provider = CredentialProvider::memoize($provider);
    $metadata = [];
                $preSignedUrl = $this->generateUploadPresignedURL("yaaas-profile-images", $photoname, "+20 minutes", $metadata, $provider);
                
               	$user->photo_url = $photoname;
               	$retobj->presignedurl = $preSignedUrl;
       	}
		
		try{
    		$user->gender_id = $gender;
    	
    		$id = R::store($user);
    		$retobj->userid = $user->id;
    		$retobj->status = "success";
		} catch (Exception $e) {
            $retobj->error = "Error updating user record: " . $e->getMessage();
            $retobj->status = "fail";
        }

        try{
    		if (count($_FILES) > 0) {
        		$target_dir = dirname(__FILE__, 3) . "/profile_images/";
        		$filename = "";
        		$tmpname = "";
        		
                $target_filename = $userid . "_profilephoto.jpg";
        		$target_file = $target_dir . $target_filename;
        		foreach ($_FILES as $file) {
        			$filename = $file['name'];
        			$tmpname = $file['tmp_name'];
        			$size = $file['size'];
        			$type = $file['type'];
        	
        			$retobj->targetfile = $target_file;
        			$retobj->file = $file["tmp_name"];
            		 if (move_uploaded_file($file["tmp_name"], $target_file)) {
            		     
            		     resizeImage($target_file, 300, 300);
            			$retobj->status = "success";
            			$user->photo_url = $target_filename;
            		 } else {
            			$retobj->status = "fail";
            		 }
        		}
    		}
    		else {
    		    	$retobj->targetfile = "none";
    		}
    		
    		
    		$user->gender_id = $gender;
    		R::store($user);
    		$retobj->userid = $user->id;
    		$retobj->status = "success";
        } catch (Exception $e) {
            $retobj->error = "Error updating user record: " . $e->getMessage();
            $retobj->status = "fail";
        }
		
		return $retobj;*/
    }
    
    protected function get() {
    	
    	$userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
            
    	$retobj = new stdClass();
    	$retobj->test = "test";
    		
          
        return $retobj;
    }
}
?>