<?php
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class settings {
    //public $db;
    function __construct() {
    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'POST not implemented');
    }
    
    protected function post($name=NULL, $fcmtoken=NULL, $username=NULL, $email=NULL, $profilephoto=NULL, $twitter=-1, $instagram=-1, $tiktok=-1, $website=-1) {
        try {
            $firebaseuserid = BasicAuth::getfirebaseuserid();
            $userid = BasicAuth::getuserid();
            $user = BasicAuth::getuser();
            if (!$user) {
                throw new RestException(400, 'Error: User not found');
            }
    
            $retobj = new stdClass();
            $retobj->modified = gmdate('Y-m-d H:i:s');
    
            try {
                // Used for push notification
                if ($fcmtoken != NULL) {
                    $user->fcmtoken = $fcmtoken;
                    $retobj->status = "FCM token stored successfully.";
                }
    
                // Updating various fields based on input
                if ($name != NULL) $user->name = $name;
                if ($email != NULL) $user->email = $email;
                if ($username != NULL) $user->username = $username;
    
                if ($profilephoto == "delete") {
                    $user->profilephoto = NULL;
                } else if ($profilephoto != NULL) {
                    // Assuming the profile photo needs to be a valid base64 string
                    $decodedPhoto = base64_decode($profilephoto, true);
                    if ($decodedPhoto === false) {
                        throw new Exception("Invalid profile photo base64 encoding.");
                    }
                    $user->profilephoto = $decodedPhoto;
                }
    
                // Social links and website
                if ($twitter != -1) $user->twitter = $twitter;
                if ($instagram != -1) $user->instagram = $instagram;
                if ($tiktok != -1) $user->tiktok = $tiktok;
                if ($website != -1) $user->website = $website;
    
                R::store($user);
            } catch (Exception $e) {
                // Log the specific error encountered during the update
                AppLogger::logError("[settings]: Error updating user profile: " . $e->getMessage(), [
                    'userid' => $userid,
                    'firebaseuserid' => $firebaseuserid
                ]);
                $retobj->error = "Failed to update profile.";
            }
    
            return $retobj;
        } catch (Exception $e) {
            // General error handling, might be redundant but ensures broad coverage
            AppLogger::logError("[settings]: General error in post method: " . $e->getMessage(), [
                'userid' => $userid,
                'firebaseuserid' => $firebaseuserid
            ]);
            throw new RestException(500, "An error occurred while processing the request.");
        }
    }

    
    protected function put($name, $version) {
        throw new RestException(501, 'POST not implemented');
    }
    
    protected function get() {
        $user = BasicAuth::getuser();
        if (!$user) {
            throw new RestException(400, 'Error: User not found');
        }
        
        $retobj = new stdClass();
        $retobj->id = $user->id;
		$retobj->username = $user->username;
		$retobj->first_name = $user->first_name;
		$retobj->last_name = $user->last_name;
		$retobj->grade = $user->grade;
		$retobj->friends_count = R::count('friendship', ' user_id = ? ', [$user->id]);
		$retobj->coins = $user->coins;
		$retobj->api_token = $user->api_token;
		$retobj->resource_token = $user->resource_token;
		
		$total_stars = R::getCell('SELECT SUM(response_count) FROM responsecount WHERE friend_id = ?', [$user->id]);
        $total_stars = $total_stars ?: 0;
        $retobj->star_count = $total_stars;
		
		 $school = R::findOne('school', ' id = ? ', [$user->school_id]);
        if ($school) {
            $retobj->school_abbrev = $school->abbrev;
		    $retobj->school_name = $school->name;
        }
		
		return $retobj;
    }
}
?>