<?php
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

use Aws\Credentials\CredentialProvider;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;

class video {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    //$video_length="25_frames_with_svd_xt"
    protected function post($video_length="14_frames_with_svd", $sizing_strategy="maintain_aspect_ratio", $frames_per_second=6, $motion_bucket_id=127, $cond_aug=0.02, $decoding_t=7, $predictionid=null){
        $retobj = new stdClass();
        
  
		$predictionid = isset($_POST["predictionid"]) ? $_POST["predictionid"] : null;
		$video_length = isset($_POST["video_length"]) ? $_POST["video_length"] : "14_frames_with_svd";
		$sizing_strategy = isset($_POST["sizing_strategy"]) ? $_POST["sizing_strategy"] : "maintain_aspect_ratio";
		$frames_per_second = isset($_POST["frames_per_second"]) ? floatval($_POST["frames_per_second"]) : 6;
		$motion_bucket_id = isset($_POST["motion_bucket_id"]) ? floatval($_POST["motion_bucket_id"]) : 127;
		$cond_aug = isset($_POST["cond_aug"]) ? floatval($_POST["cond_aug"]) : 0.02;
		$decoding_t = isset($_POST["decoding_t"]) ? floatval($_POST["decoding_t"]) : 8;
		
		ini_set('max_execution_time', '500');
		
        if (count($_FILES) <= 0) {
            throw new RestException(400, 'You must supply a png image');
        }
		
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
		if($user->credits <=0){
		    throw new RestException(402, 'Error: You have run out of credits. You need to purchase more to create a video from this image.');
		}
		
		$target_dir = dirname(__FILE__, 3) . "/video/";
		$filename = "";
		$tmpname = "";
		
		$uuid = generateUUIDv4();
		$target_file = $target_dir . $userid . "_" . $uuid . "_original.png";
		// file_put_contents('filename.log', "name: " . $target_file);
		foreach ($_FILES as $file) {
			$filename = $file['name'];
			$tmpname = $file['tmp_name'];
			$size = $file['size'];
			$type = $file['type'];
			
	
			$retobj->targetfile = $target_file;
			$retobj->file = $file["tmp_name"];
    		 if (move_uploaded_file($file["tmp_name"], $target_file)) {
    			$retobj->status = "success";
    		 } else {
    			$retobj->status = "fail";
    		 }
		}
		
		//need to upload original file to digital ocean and store link in db
		//then we will need to do the same with the resulting output
		
		//must skip digital ocean for now to avoid costs
		$filePath = $target_file;
		$keyName = basename($filePath);
		$original = "https://myrestfulapi.com/ellisapps/dalle/video/".$keyName;
		
		//file_put_contents('original.log', "original: " . $target_file);
		
	/*	$provider = CredentialProvider::ini(null, '/home/myrestfulapi/.aws/credentials');
        $provider = CredentialProvider::memoize($provider);

		$s3 = new S3Client([
			'version' => 'latest',
			'region'  => 'nyc3', // e.g., 'nyc3'
			'endpoint' => 'https://nyc3.digitaloceanspaces.com',
			'credentials' => $provider
		
		]);
		
		$filePath = $target_file;
		$keyName = basename($filePath);
		
		try {
			// Upload the file
			$result = $s3->putObject([
				'Bucket' => 'deep-a',
				'Key'    => $keyName,
				'Body'   => fopen($filePath, 'r'),
				'ACL'    => 'public-read', // or 'private'
			]);

			$original = $result['ObjectURL'];
			//echo "File uploaded successfully. File URL: " . $result['ObjectURL'] . PHP_EOL;
		} catch (AwsException $e) {
			// Output error message if something goes wrong
			//echo "Error: " . $e->getMessage() . PHP_EOL;
		}*/

		
		$version = "3f0457e4619daac51203dedb472816fd4af51f3149fa7a9e0b5ffcf1b8172438";
		
		$ipaddress = getIP();
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = "video";
		$newlog->style = "video";
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		$video = R::dispense('video');
		$video->uuid = $uuid;
		$video->version = $version;
		$video->predictionid = $predictionid;
		$video->original = $original;
		$video->cond_aug = $cond_aug;
		$video->decoding_t = $decoding_t;
		$video->video_length = $video_length;
		$video->sizing_strategy = $sizing_strategy;
		$video->motion_bucket_id = $motion_bucket_id;
		$video->frames_per_second = $frames_per_second;
		$video->status = "starting";
		
		$user->ownVideoList[] = $video;
		
		R::store($user);
		$videoid = $video->id;
		$retobj->id = $videoid;
		
		//ok we need to hit the replicate api to  upscale this image
		//then we need to poll the db looking for completion from ios app
		
		$data = [
            "version" => $version,
            "input" => [
                "cond_aug" => $cond_aug,
                "input_image" => $original, //"https://myrestfulapi.com/ellisapps/dalle/video/" . $userid . "_" . $uuid . "_original.png",
                "decoding_t" => $decoding_t,
                "video_length" => $video_length,
                "sizing_strategy" => $sizing_strategy,
                "motion_bucket_id" => $motion_bucket_id,
                "frames_per_second" => $frames_per_second
            ],
            "webhook_completed" => 'https://myrestfulapi.com/ellisapps/dalle/api/videocompleted?videoid='.$videoid
        ];
        
		$header = array();
		$header[] = 'Authorization: Token '. REPLICATE_API_TOKEN;
		$header[] = 'Content-type: application/json';
		
		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.replicate.com/v1/predictions");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        if(curl_errno($ch)) {
            //echo 'Error:' . curl_error($ch);
        }
        
        curl_close($ch);

		$obj = json_decode($response);
		if ($obj !== null && property_exists($obj, 'status')) {
			$video->status = $obj->status;
			R::store($video);
		}
		else {
			//invalid json or no model property
		}

		
		$credits = $user->credits - 1;
		if($credits < 0) $credits = 0;
		$user->credits = $credits;
		
		
		R::store($user);
		
		/*if (file_exists($target_file)) {
            unlink($target_file);
        }*/


		return $retobj;
		
    }
    
    function get() {
    	throw new RestException(501, 'GET not implemented');
    }
}
?>