<?php
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

use Aws\Credentials\CredentialProvider;
use Aws\S3\S3Client;
use Aws\Exception\AwsException;

class upscale {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($prompt=" ", $negativeprompt=" ", $resemblence=1.0, $creativity=0.75, $hdr=1.0, $steps=20, $guidance_scale=5.0, $guessmode=0, $predictionid=null){
        $retobj = new stdClass();
        
        //for some reason when we upload files our paramters do not come through
        //so we have to set them up here manually. 
        $negativeprompt = isset($_POST["negativeprompt"]) ? $_POST["negativeprompt"] : " ";
		$prompt = isset($_POST["prompt"]) ? $_POST["prompt"] : " ";
		$resemblence = isset($_POST["resemblence"]) ? floatval($_POST["resemblence"]) : 1.0;
		$creativity = isset($_POST["creativity"]) ? floatval($_POST["creativity"]) : 0.75;
		$hdr = isset($_POST["hdr"]) ? floatval($_POST["hdr"]) : 1.0;
		$steps = isset($_POST["steps"]) ? floatval($_POST["steps"]) : 20;
		$guidance_scale = isset($_POST["guidance_scale"]) ? floatval($_POST["guidance_scale"]) : 5.0;
		$guessmode = isset($_POST["guessmode"]) ? intval($_POST["guessmode"]) : 0.0;
		$predictionid = isset($_POST["predictionid"]) ? $_POST["predictionid"] : null;
		

		
		ini_set('max_execution_time', '500');
		
        if (count($_FILES) <= 0) {
            throw new RestException(400, 'You must supply a png image to upscale');
        }
		
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
		if($user->credits <=0){
		    throw new RestException(402, 'Error: You have run out of credits. You need to purchase more to upscale this image.');
		}
		
		$target_dir = dirname(__FILE__, 3) . "/upscale/";
		$filename = "";
		$tmpname = "";
		
		$uuid = generateUUIDv4();
		$target_file = $target_dir . $userid . "_" . $uuid . "_original.png";
		// file_put_contents('filename.log', "name: " . $target_file);
		foreach ($_FILES as $file) {
			$filename = $file['name'];
			$tmpname = $file['tmp_name'];
			$size = $file['size'];
			$type = $file['type'];
			
	
			$retobj->targetfile = $target_file;
			$retobj->file = $file["tmp_name"];
    		 if (move_uploaded_file($file["tmp_name"], $target_file)) {
    			$retobj->status = "success";
    		 } else {
    			$retobj->status = "fail";
    		 }
		}
		
		//need to upload original file to digital ocean and store link in db
		//then we will need to do the same with the resulting output
		
		//must skip digital ocean for now to avoid costs
		$filePath = $target_file;
		$keyName = basename($filePath);
		$original = "https://myrestfulapi.com/ellisapps/dalle/upscale/".$keyName;
		
		//file_put_contents('original.log', "original: " . $target_file);
		
	/*	$provider = CredentialProvider::ini(null, '/home/myrestfulapi/.aws/credentials');
        $provider = CredentialProvider::memoize($provider);

		$s3 = new S3Client([
			'version' => 'latest',
			'region'  => 'nyc3', // e.g., 'nyc3'
			'endpoint' => 'https://nyc3.digitaloceanspaces.com',
			'credentials' => $provider
		
		]);
		
		$filePath = $target_file;
		$keyName = basename($filePath);
		
		try {
			// Upload the file
			$result = $s3->putObject([
				'Bucket' => 'deep-a',
				'Key'    => $keyName,
				'Body'   => fopen($filePath, 'r'),
				'ACL'    => 'public-read', // or 'private'
			]);

			$original = $result['ObjectURL'];
			//echo "File uploaded successfully. File URL: " . $result['ObjectURL'] . PHP_EOL;
		} catch (AwsException $e) {
			// Output error message if something goes wrong
			//echo "Error: " . $e->getMessage() . PHP_EOL;
		}*/

		
		$version = "4af11083a13ebb9bf97a88d7906ef21cf79d1f2e5fa9d87b70739ce6b8113d29";
		
		$ipaddress = getIP();
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = "upscale";
		$newlog->style = "upscale";
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		$upscale = R::dispense('upscale');
		$upscale->uuid = $uuid;
		$upscale->version = $version;
		$upscale->predictionid = $predictionid;
		$upscale->prompt = $prompt;
		$upscale->negativeprompt = $negativeprompt;
		$upscale->original = $original;
		$upscale->resemblence = $resemblence;
		$upscale->creativity = $creativity;
		$upscale->hdr = $hdr;
		$upscale->steps = $steps;
		$upscale->guidancescale = $guidance_scale;
		$upscale->guessmode = $guessmode;
		$upscale->status = "starting";
		
		$user->ownUpscaleList[] = $upscale;
		
		R::store($user);
		$upscaleid = $upscale->id;
		$retobj->id = $upscaleid;
		
		//ok we need to hit the replicate api to  upscale this image
		//then we need to poll the db looking for completion from ios app
		
		$data = [
            "version" => $version,
            "input" => [
                "hdr" => $hdr,
                "image" => $original, //"https://myrestfulapi.com/ellisapps/dalle/upscale/" . $userid . "_" . $uuid . "_original.png",
                "steps" => $steps,
                "prompt" => $prompt,
                "scheduler" => "DDIM",
                "creativity" => $creativity,
                "guess_mode" => $guessmode == 1 ? true : false,
                "resolution" => 2048,
                "resemblance" => $resemblence,
                "guidance_scale" => $guidance_scale,
                "negative_prompt" => $negativeprompt
            ],
            "webhook_completed" => 'https://myrestfulapi.com/ellisapps/dalle/api/upscalecompleted?upscaleid='.$upscaleid
        ];
        
		$header = array();
		$header[] = 'Authorization: Token '. REPLICATE_API_TOKEN;
		$header[] = 'Content-type: application/json';
		
		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.replicate.com/v1/predictions");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        if(curl_errno($ch)) {
            //echo 'Error:' . curl_error($ch);
        }
        
        curl_close($ch);

		$obj = json_decode($response);
		if ($obj !== null && property_exists($obj, 'model')) {
			$upscale->model = $obj->model;
			$upscale->status = $obj->status;
			R::store($upscale);
		}
		else {
			//invalid json or no model property
		}

		
		$credits = $user->credits - 1;
		if($credits < 0) $credits = 0;
		$user->credits = $credits;
		
		
		R::store($user);
		
		/*if (file_exists($target_file)) {
            unlink($target_file);
        }*/


		return $retobj;
		
    }
    
    function get() {
    	throw new RestException(501, 'GET not implemented');
    }
}
?>