<?php
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

class published {
    //public $db;
    function __construct() {

    }
    protected function delete($publishid) {
        //throw new RestException(501, 'POST not implemented');
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
        if (!$user) {
            throw new RestException(400, 'User not found');
        }
        
        if (!$publishid) {
            throw new RestException(400, 'Publish identifier not supplied');
        }
        
        $retobj = new stdClass();
        
        $published = R::findOne('published', ' id = ? AND user_id = ? ', array($publishid, $userid));
        if($published){
            try{
                $published->active = 0;
                R::store($published);
                
                $retobj->status = "success";
            }
            catch(Exception $e) {
                $retobj->status = "fail";
                $retobj->errormessage = $e->getMessage();
            }
        }
        else{
              $retobj->status = "fail";
              $retobj->errormessage = "Published image not found";
        }
    	
    	
    	return $retobj;
    }
    
     protected function post($title="", $prompt="", $style="", $predictionid="", $type="prompt") {
		
		$userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
		
		$title = $_POST["title"];
		$prompt = $_POST["prompt"];
		$style = $_POST["style"];
		$gentype = $_POST["type"];
		$predictionid = $_POST["predictionid"];
		
		$title = str_replace("\r\n",'', $title);
		 $style = str_replace("\r\n",'', $style);
		 $prompt = str_replace("\r\n",'', $prompt);
		 $gentype = str_replace("\r\n",'', $gentype);
		 $predictionid = str_replace("\r\n",'', $predictionid);
		 if(!empty($predictionid)) { 
		    $check = R::findOne("published", " predictionid = ? AND user_id = ? ", array($predictionid, $userid));
		    if($check != NULL){
		        if($check->active == 0){
		                $check->active = 1;
		                R::store($check);
		            	$ret = new stdClass();
		            	$ret->status = "success";
		            	$ret->publishedid = $check->id;
		                $ret->modified = gmdate('Y-m-d H:i:s');
		                return $ret;
		        }
		        else {
		            throw new RestException(403, 'Has already been published');
		        }
		    }
		 }
		
        if (count($_FILES) <= 0) {
            throw new RestException(400, 'Images must be supplied');
        }
		
		if (!$user) {
            throw new RestException(400, 'User not found');
        }
		
		
		//save the entries in the database
		$retobj = new stdClass();
		R::begin();
		try{
		    
		     $publishedCount = R::count( 'published', ' user_id = ? ', array($userid) );
		     
	    	$target_dir = dirname(__FILE__, 3) . "/published/";

            $filename = "";
            $tmpname = "";
            $size = 0;
            $type = 0;
    		
    		$index = 0;
    		
    		 $published = R::dispense("published");
    		 $published->predictionid = $predictionid;
		    $published->title = $title;
		    $published->prompt = $prompt;
		    $published->style = $style;
		    $published->datecreated = gmdate('Y-m-d H:i:s');
            $published->datemodified = gmdate('Y-m-d H:i:s');
            $published->type = $gentype;
            $published->active = 1;
    		
	        foreach ($_FILES as $file) {
                $filename = $file['name'];
                $tmpname = $file['tmp_name'];
                $size = $file['size'];
                $type = $file['type'];
    			
    			$target_file = $target_dir . $userid . "_" . $publishedCount . "_publish".$index.".jpg";
    			
    			if($index == 0) {
    			    $published->featureimage = $userid . "_" . $publishedCount . "_publish".$index.".jpg";
    			}
    			if($index == 4) {
    			    $published->featureimage = $userid . "_" . $publishedCount . "_publish".$index.".jpg";
    			}
    			
    			if($index == 5){
					$target_file = $target_dir . $userid . "_" . $publishedCount . "_publish_original.jpg";
					$published->originalimage = $userid . "_" . $publishedCount . "_publish_original.jpg";
				}
    			
    			  $retobj->targetfile = $target_file;
    			  $retobj->file = $file["tmp_name"];
        		  if (move_uploaded_file($file["tmp_name"], $target_file)) {
        			$retobj->status = "success";
        		  } else {
        			$retobj->status = "fail";
        		  }
        		  
        		
        		if($index < 4){  
            		$image = R::dispense("image");
                    $image->name = $userid . "_" . $publishedCount . "_publish".$index.".jpg";
                    $image->datecreated = gmdate('Y-m-d H:i:s');
                    $image->datemodified = gmdate('Y-m-d H:i:s');
                    $image->active = 1;
                    
                    
                    $published->ownImage[] = $image;
        		}
    		 
    		  $index++;
            }
		    
		    $user->ownPublished[] = $published;
		    $publishedid = R::store($published);
		    R::store($user);
		    $retobj->publishedid = $publishedid;
		    $retobj->modified = gmdate('Y-m-d H:i:s');
		    R::commit();
        }
        catch(Exception $e) {
            $retobj->status = "fail";
            $retobj->errormessage = $e->getMessage();
            R::rollback();
        }
		
	
		
		return $retobj;

    }
    protected function put($name, $version) {
        throw new RestException(501, 'POST not implemented');
    }
    
  protected function get($offset = 0, $limit = 0, $uid = -1, $likes = 0, $following = 0, $top = 0) {
        //if likes is passed in we only return images liked by current user
        //if following is passed in we only return images from people the current user follows
        //if top is passed in we only return a list of users sorted by the one that has the most likes across all images
        //otherwise we just return all published images starting with the latest ones
        
        //if its a logged in users we can
        //tailor the topic list to them if we like
        //if not then we just list em all
       $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
		
		$usersql = "";
        if($uid>0){
            $usersql = " p.user_id = " . $uid . " AND";
        }
        
        $likesql = "";
        if ($likes == 1) {
            // If likes = 1, fetch only those images liked by the current user ($userid)
            $likesql = " JOIN `like` l ON p.id = l.published_id AND l.user_id = " . $userid . " ";
        }
        
        $limitsql = '';
        if($limit>0)
            $limitsql = ' LIMIT '.$limit.' OFFSET '.$offset;
            
        
        if($likes == 1){ //only show images liked by the current user
            //SELECT p.* FROM published p JOIN `like` l ON p.id = l.published_id WHERE l.user_id = 7 AND p.active = 1;
              $published = R::getAll("SELECT p.id, p.predictionid, p.title, p.featureimage, p.originalimage, p.type, p.prompt, p.style, p.datecreated, p.datemodified, p.active, p.user_id, u.username FROM published p RIGHT JOIN user u ON u.id = p.user_id JOIN `like` l ON p.id = l.published_id WHERE l.user_id = " . $userid . " AND p.active = 1 AND u.active = 1 ORDER BY l.id DESC".$limitsql);
      
        }
        else if($top == 1){
             $published = R::getAll(" SELECT u.id as userid, u.username, COUNT(DISTINCT p.id) as imagecount, COUNT(l.user_id) as likecount FROM user u JOIN published p ON u.id = p.user_id JOIN `like` l ON p.id = l.published_id GROUP BY u.id ORDER BY likecount DESC LIMIT 100; ");

        }
        else if($following == 1){ //only show images from people the current user follows
            $published = R::getAll("SELECT p.id, p.predictionid, p.title, p.featureimage, p.originalimage, p.type, p.prompt, p.style, p.datecreated, p.datemodified, p.active, p.user_id, u.username FROM published p RIGHT JOIN user u ON u.id = p.user_id JOIN follows f ON u.id = f.followedid WHERE f.followerid = " . $userid . " AND f.active = 1 AND p.active = 1 AND u.active = 1 ORDER BY p.id DESC".$limitsql);

        }
        else {
              $published = R::getAll("SELECT p.id, p.predictionid, p.title, p.featureimage, p.originalimage, p.type, p.prompt, p.style, p.datecreated, p.datemodified, p.active, p.user_id, u.username FROM published p RIGHT JOIN user u ON u.id = p.user_id WHERE" . $usersql . " p.active = 1 AND u.active = 1 ORDER BY p.id DESC".$limitsql);
      //      file_put_contents("sql.txt", "SELECT p.id, p.predictionid, p.title, p.featureimage, p.originalimage, p.type, p.prompt, p.style, p.datecreated, p.datemodified, p.active, p.user_id, u.username FROM published p RIGHT JOIN user u ON u.id = p.user_id WHERE" . $usersql . " p.active = 1 AND u.active = 1 ORDER BY p.id DESC".$limitsql);
        }
        
       // $published = R::getAll("SELECT p.id, p.title, p.featureimage, p.originalimage, p.type, p.prompt, p.style, p.datecreated, p.datemodified, p.active, p.user_id, u.username FROM published p " . $likesql . " RIGHT JOIN user u ON u.id = p.user_id WHERE" . $usersql . " p.active = 1 ORDER BY p.id DESC".$limitsql);
        
		/*$published = R::getAll("SELECT id, title, featureimage, prompt, style, datecreated, datemodified, active, user_id FROM published WHERE active = 1 ORDER BY id DESC".$limitsql);*/
		if($top != 1){
    		for($i=0; $i<count($published); $i++){
    			$item = $published[$i];
    			//$published[$i]["username"] = $user->username;
    		
    			$likecount = R::count('like', ' published_id = ? ', array($item["id"]));
    			$published[$i]["likecount"] = $likecount;
    			
    			$userlike = R::findOne('like', ' user_id = ? AND published_id = ? ', array($userid, $item["id"]));
    			$liked = 0;
    			if($userlike) $liked = 1;
    			$published[$i]["liked"] = $liked;
    			
    			$images = R::getAll("SELECT * FROM image WHERE published_id = ? ", array($item["id"]));
    			$published[$i]["images"] = $images;
    			
    		}
		}

		return $published;
    }
}
?>