<?php
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

class generate {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($prompt, $width=512, $height=512, $num_outputs=1){
        if (!$prompt) {
			throw new RestException(400, 'Error: You must supply a description of the image you want to create');
		}
		
		if(!in_array($width, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Width must be either 128, 256, 512, 768, or 1024');
		}
		
		if(!in_array($height, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Height must be either 128, 256, 512, 768, or 1024');
		}
			
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
		if($user->credits <= 0 && $user->lifetime <= 0){
			throw new RestException(402, 'Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art.');
		}
		
		$ratelimit = R::load('ratelimit', 1);
		
		$ipaddress = getIP();
		$current = gmdate('Y-m-d H:i:s');
		$minuteago = new \DateTime($current, new DateTimeZone('UTC'));
		$minuteago->modify("-".$ratelimit->durationseconds." seconds");

		$logs = R::find('log', ' ipaddress = ? OR user_id = ? LIMIT 5 ', array($ipaddress, $userid));
		$count = 0;
		foreach($logs as $log){
			$logtime = new \DateTime($log->datetime, new DateTimeZone('UTC'));
			if($logtime > $minuteago){
				$count++;
			}
		}

		if($count >= $ratelimit->maxcalls){
			throw new RestException(429, 'Error: Too many requests');
		}
		
		//ok so now we can run the api
		$header = array();
		$header[] = 'Authorization: Token '. REPLICATE_API_TOKEN;
		$header[] = 'Content-type: application/json';


		$data = ['version' => 'a9758cbfbd5f3c2094457d996681af52552901775aa2d6dd0b17fd15df959bef', 'input' => ['prompt' => $prompt, 'width' => $width, 'height' => $height, 'num_outputs' => $num_outputs], 'webhook_completed' => 'https://myrestfulapi.com/endlessloopapps/aiartgenerator/api/predictioncompleted'];
		$postdata = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://api.replicate.com/v1/predictions");
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		$response   = curl_exec($ch);
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = $prompt;
		$newlog->style = "";
		$newlog->width = $width;
		$newlog->height = $height;
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		
		$obj = json_decode($response);
	
		$prediction = R::dispense('prediction');
		$prediction->predictionid = $obj->id;
		$prediction->prompt = $obj->input->prompt;
		$prediction->numoutputs = $obj->input->num_outputs;
		$prediction->status = $obj->status;		
		$prediction->version = $obj->version;
		$prediction->geturl = $obj->urls->get;
		$prediction->cancelurl = $obj->urls->cancel;
		$user->ownPredictionList[] = $prediction;
		
		$credits = $user->credits - 1;
		if($credits < 0) $credits = 0;
		$user->credits = $credits;
		
		R::store($user);
			 
		return $obj;
    }
    
	protected function get() {
		
		throw new RestException(501, 'GET not implemented');
	}
    
}
?>