<?php
error_reporting (E_ALL ^ E_NOTICE); 
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');


class edits {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
	protected function post($prompt, $width=512, $height=512, $num_outputs=4, $appversion="1.0", $freecreditsenabled="0"){
			
			$retobj = new stdClass();
			
			$prompt = str_replace(array("\r", "\n"), '', $_POST["prompt"]);
			$num_outputs = str_replace(array("\r", "\n"), '', $_POST["num_outputs"]);
			$width = str_replace(array("\r", "\n"), '', $_POST["width"]);
			$height = str_replace(array("\r", "\n"), '', $_POST["height"]);
			
			ini_set('max_execution_time', '500');
		
		 if (!$prompt) {
			throw new RestException(400, 'Error: You must supply a description of the image you want to create');
		}
		
        if (count($_FILES) <= 0) {
            throw new RestException(400, 'A square png image must be supplied');
        }
		
		if(!in_array($width, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Width must be either 128, 256, 512, 768, or 1024');
		}
		
		if(!in_array($height, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Height must be either 128, 256, 512, 768, or 1024');
		}
			
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
			$versionNumber = floatval($appversion);
		if($user->credits <=0 && $user->lifetime <=0 && $user->awardedfreecredits == 0 && $versionNumber >= 3.1 && $freecreditsenabled == "1"){
		    $user->credits = 5;
		    $user->awardedfreecredits = 1;
		    R::store($user);
		    throw new RestException(403, 'You have been awarded 5 more credits for FREE.');
		}
		else if($user->credits <= 0 && $user->lifetime <= 0){
			throw new RestException(402, 'Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art.');
		}
		
		$ratelimit = R::load('ratelimit', 1);
		
		$ipaddress = getIP();
		$current = gmdate('Y-m-d H:i:s');
		$minuteago = new \DateTime($current, new DateTimeZone('UTC'));
		$minuteago->modify("-".$ratelimit->durationseconds." seconds");

		$logs = R::find('log', ' ipaddress = ? OR user_id = ? LIMIT 5 ', array($ipaddress, $userid));
		$count = 0;
		foreach($logs as $log){
			$logtime = new \DateTime($log->datetime, new DateTimeZone('UTC'));
			if($logtime > $minuteago){
				$count++;
			}
		}

		if($count >= $ratelimit->maxcalls){
			throw new RestException(429, 'Error: Too many requests');
		}
		
		$target_dir = dirname(__FILE__, 3) . "/variation/";

		$filename = "";
		$tmpname = "";
		$size = 0;
		$type = 0;
		
		$index = 0;
		
		$target_file = "";
		$target_image_file = $target_dir . $userid . "_edit.png";
		$target_mask_file = $target_dir . $userid . "_mask.png";
		
		foreach ($_FILES as $key=>$value) {
			$file = $value;
			
			if($key == "image"){
				$target_file = $target_image_file;
			}
			else if($key == "mask"){
				$target_file = $target_mask_file;
			}
			
			$filename = $file['name'];
			$tmpname = $file['tmp_name'];
			$size = $file['size'];
			$type = $file['type'];
			
			
			
			$retobj->targetfile = $target_file;
			$retobj->file = $file["tmp_name"];
		  if (move_uploaded_file($file["tmp_name"], $target_file)) {
			$retobj->status = "success";
		  } else {
			$retobj->status = "fail";
		  }
		 
		  $index++;
		}
			
			
		
		$initialDelay = 1000; //1 second
		$maxRetries = 8;
		$maxDelay = 128000;
		$retries = 0;
		$delay = $initialDelay;
		
		

		$file = new \CURLFile($target_file); 
		$mask = new \CURLFile($target_mask_file); 
		$data = array('prompt' => $prompt, 'n' => $num_outputs, 'size' => $width . 'x' . $height, 'image' => $file, 'mask' => $mask, 'user' => $userid);

		$headers = [ 'Authorization: Bearer '. OPENAI_API_KEY];

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/images/edits');
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SAFE_UPLOAD, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	
	
		$httpCode = 200;
		
		do {
			$response   = curl_exec($ch);
			//print($response);
			
			//stasrt new code
			//might need to check 429 in json
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			
			// Check for 429 error
			if ($httpCode == 429) {
			  // Handle 429 error
			  $retries++;
			  $delay *= 2;
			  $randomMS = rand(0, 1000);
			  $delay += $randomMS;
			  
			  if($delay > $maxDelay){
				$delay = $maxDelay;
			  }
			  
			  /*$file_handle = fopen('retry.txt', 'a');
			 fwrite($file_handle, "retry count: " . $retries . " - delay: " . $delay . "\r\n");
			 fclose($file_handle);*/
			  
			  $finaldelay = $delay * 1000;
			  usleep($finaldelay);
			  
			}

		} while($httpCode == 429 && $retries < $maxRetries);

		$status = "succeeded";
		$errormessage = "";
		
		if($httpCode == 429) {
			$status = "failed";
			$errormessage = "429: Too many requests";
		}
		else if($response === false || $httpCode != 200){
			//we have an error
			$status = "failed";
			$errormessage = curl_error($ch);
		}
		
		curl_close($ch);
		
/*
{
  "created": 1667850415,
  "data": [
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-Ywi0xM7wlCZv6m98RH4gFTfX.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=rqocyelnVkmv1FjjcOsI1Rg2czUBHmkeAwnAU55iV8s%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-5satOwdtLIq4cS6S1IZ8ezX3.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=Hp/T3zWFkyB1O8QS1Oz5qw6OOuu%2BpXnwU3T%2BddLaoL0%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-xIdfzuA0s6k88OP6aEiJ1J1g.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=lP4dJCGhKudl/spMJJNyDaYseJGNrJcARswfxAI71pA%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-3clrk1nzU3NCEdLmOSHCPXi9.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=sns9/q4RGPkldvDHh%2BG5IsCY2%2B7hz/jpHS4bUq8A2wo%3D"
    }
  ]
}





{
"error": {
"code": 402,
"message": "Payment Required: Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art."
}
}
*/




		//take json response parse it and store in database
		//var_dump($response);
		/*
		$file_handle = fopen('generateresponse.json', 'w');
		fwrite($file_handle, $response);
		fclose($file_handle);
		*/
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = "edits";
		$newlog->style = "edits";
		$newlog->width = $width;
		$newlog->height = $height;
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		
		$obj = json_decode($response);
		
		
		
		if(isset($obj->error)){
			$status = "failed";
			$errormessage = $obj->error->message;
		}
		
	
		$prediction = R::dispense('prediction');
		$predictionid = "DALL-E_".randString(22, "mixed", "");
		$prediction->predictionid = $predictionid;
		$prediction->prompt = $prompt;
		$prediction->style = "edits";
		$prediction->numoutputs = $num_outputs;
		$prediction->status = $status;		
		$prediction->errormessage = $errormessage;
		$prediction->version = "v1";
		$prediction->type = "edit";
		
		if(isset($obj->data)){
			if(count($obj->data) > 0){
				$prediction->output = $obj->data[0]->url;
			}
			
			if(count($obj->data) > 1){
				$prediction->output2 = $obj->data[1]->url;
			}
			
			if(count($obj->data) > 2){
				$prediction->output3 = $obj->data[2]->url;
			}
			
			if(count($obj->data) > 3){
				$prediction->output4 = $obj->data[3]->url;
			}
		}
		

		$user->ownPredictionList[] = $prediction;
		
		$credits = $user->credits - 1;
		if($credits < 0) $credits = 0;
		$user->credits = $credits;
		
		R::store($user);
		$obj->id = $predictionid;
		$obj->pid = $prediction->id;
		$obj->num = $num_outputs;
		
		
		if (file_exists($target_image_file)) {
            unlink($target_image_file);
        }
	    
	    if (file_exists($target_mask_file)) {
            unlink($target_mask_file);
        }
		
		return $obj;
	}
    
	function get() {
		
			throw new RestException(501, 'GET not implemented');
		}
	}
?>