<?php
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

class dallegenerate {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($prompt, $width=512, $height=512, $num_outputs=1){
        if (!$prompt) {
			throw new RestException(400, 'Error: You must supply a description of the image you want to create');
		}
		
		if(!in_array($width, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Width must be either 128, 256, 512, 768, or 1024');
		}
		
		if(!in_array($height, array(128, 256, 512, 768, 1024))){
			throw new RestException(400, 'Error: Height must be either 128, 256, 512, 768, or 1024');
		}
			
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
		if($user->credits <= 0 && $user->lifetime <= 0){
			throw new RestException(402, 'Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art.');
		}
		
		$ratelimit = R::load('ratelimit', 1);
		
		$ipaddress = getIP();
		$current = gmdate('Y-m-d H:i:s');
		$minuteago = new \DateTime($current, new DateTimeZone('UTC'));
		$minuteago->modify("-".$ratelimit->durationseconds." seconds");

		$logs = R::find('log', ' ipaddress = ? OR user_id = ? LIMIT 5 ', array($ipaddress, $userid));
		$count = 0;
		foreach($logs as $log){
			$logtime = new \DateTime($log->datetime, new DateTimeZone('UTC'));
			if($logtime > $minuteago){
				$count++;
			}
		}

		if($count >= $ratelimit->maxcalls){
			throw new RestException(429, 'Error: Too many requests');
		}
		
		//ok so now we can run the api
		/*$header = array();
		$header[] = 'Authorization: Token '. REPLICATE_API_TOKEN;
		$header[] = 'Content-type: application/json';

		//$headers = [ 'Authorization: Token '. REPLICATE_API_TOKEN];
		//$POST = ['version' => 'a9758cbfbd5f3c2094457d996681af52552901775aa2d6dd0b17fd15df959bef', 'input' => '{"prompt":"'.$prompt.'"}', 'webhook_completed' => 'https://myrestfulapi.com/endlessloopapps/aiartgenerator/api/predictioncompleted'];
		$data = ['version' => 'a9758cbfbd5f3c2094457d996681af52552901775aa2d6dd0b17fd15df959bef', 'input' => ['prompt' => $prompt, 'width' => $width, 'height' => $height, 'num_outputs' => $num_outputs], 'webhook_completed' => 'https://myrestfulapi.com/endlessloopapps/aiartgenerator/api/predictioncompleted'];
		$postdata = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://api.replicate.com/v1/predictions");
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		$response   = curl_exec($ch);*/
		
		$headers = [ 'Authorization: Bearer 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',
'Content-Type: application/json'];
		$POST = '{"prompt": "' . $prompt . '", "n": ' . $num_outputs . ', "size":  "'.$width.'x'.$height.'", "user": "'. $user->id . '"}';


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/images/generations");
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $POST);
		$response   = curl_exec($ch);
		//print($response);



		$status = "succeeded";
		$errormessage = "";
		if($response === false)
		{
			$status = "failed";
			$errormessage = curl_error($ch);
		}
		
/*
{
  "created": 1667850415,
  "data": [
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-Ywi0xM7wlCZv6m98RH4gFTfX.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=rqocyelnVkmv1FjjcOsI1Rg2czUBHmkeAwnAU55iV8s%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-5satOwdtLIq4cS6S1IZ8ezX3.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=Hp/T3zWFkyB1O8QS1Oz5qw6OOuu%2BpXnwU3T%2BddLaoL0%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-xIdfzuA0s6k88OP6aEiJ1J1g.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=lP4dJCGhKudl/spMJJNyDaYseJGNrJcARswfxAI71pA%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-3clrk1nzU3NCEdLmOSHCPXi9.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=sns9/q4RGPkldvDHh%2BG5IsCY2%2B7hz/jpHS4bUq8A2wo%3D"
    }
  ]
}





{
"error": {
"code": 402,
"message": "Payment Required: Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art."
}
}
*/




		//take json response parse it and store in database
		//var_dump($response);
		/*
		$file_handle = fopen('generateresponse.json', 'w');
		fwrite($file_handle, $response);
		fclose($file_handle);
		*/
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = $prompt;
		$newlog->style = "";
		$newlog->width = $width;
		$newlog->height = $height;
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		
		$obj = json_decode($response);
		
		
		
		if(isset($obj->error)){
			$status = "failed";
			$errormessage = $obj->error->message;
		}
		
	
		$prediction = R::dispense('prediction');
		$predictionid = "DALL-E_".randString(22, "mixed", "");
		$prediction->predictionid = $predictionid;
		$prediction->prompt = $prompt;
		$prediction->numoutputs = $num_outputs;
		$prediction->status = $status;		
		$prediction->errormessage = $errormessage;
		$prediction->version = "v1";
		
		if(isset($obj->data)){
			if(count($obj->data) > 0){
				$prediction->output = $obj->data[0]->url;
			}
			
			if(count($obj->data) > 1){
				$prediction->output2 = $obj->data[1]->url;
			}
			
			if(count($obj->data) > 2){
				$prediction->output3 = $obj->data[2]->url;
			}
			
			if(count($obj->data) > 3){
				$prediction->output4 = $obj->data[3]->url;
			}
		}
		
		//$prediction->geturl = $obj->urls->get;
		//$prediction->cancelurl = $obj->urls->cancel;
		
		
		
		$user->ownPredictionList[] = $prediction;
		
		$credits = $user->credits - 1;
		if($credits < 0) $credits = 0;
		$user->credits = $credits;
		
		R::store($user);
		$obj->id = $predictionid;
		return $obj;
    }
    
	protected function get() {
		
		throw new RestException(501, 'GET not implemented');
	}
    
}
?>