<?php
require_once __DIR__ . '/../../vendor/autoload.php';
//require_once ('../libs/aws.phar');
require_once ('../libs/rb.php');
require_once ('../libs/db.php');

//https://github.com/aporat/store-receipt-validator
use ReceiptValidator\iTunes\Validator as iTunesValidator;


/*
 function validateReceipt($receiptData){
		$valid = false;
        $expiresdate = "";
        $requestdate = "";
          
        $validator = new iTunesValidator(iTunesValidator::ENDPOINT_SANDBOX);
        $receiptBase64Data = $receiptData; 

        try {
            $response = $validator->setSharedSecret(APP_SPECIFIC_SHARED_SECRET)->setReceiptData($receiptBase64Data)->validate(); // use setSharedSecret() if for recurring subscriptions
			
			if ($response->isValid()) {
				$requestdate = $response->getRequestDate();
				$renewal = $response->getPendingRenewalInfo();
				$receiptinfoarray = $response->getLatestReceiptInfo();
				$nonCancelledReceiptInfoArray = array();
				
				//filter out cancelled receipts because they are useless
				foreach ($receiptinfoarray as $item) {
					if($item->getCancellationDate() == null){
						array_push($nonCancelledReceiptInfoArray, $item);
					}
				}
				
				if($firstitem = reset($nonCancelledReceiptInfoArray)){
					$expiresdate = $firstitem->getExpiresDate();

					 if($expiresdate > $requestdate){
						 $valid = true;
						$result = "PURCHASED";
					 }
					 else{
						$valid = false;
						$result = "EXPIRED";
					 }
				}
				else{
					$valid = false;
					$result = "NOT_PURCHASED";
				}
		  }
		  else {
			  $valid = false;
		  }
		} catch (Exception $e) {
            
            echo 'got error = ' . $e->getMessage() . PHP_EOL;
        }
		  return $valid;
	}	*/
    

class dallegenerate {
    //public $db;
    function __construct() {

    }
    
   
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($prompt, $width=512, $height=512, $num_outputs=1, $style=NULL, $gentype="prompt", $appversion="1.0", $freecreditsenabled=false, $dalleversion=2){
		
		ini_set('max_execution_time', '500');
		
        if (!$prompt) {
			throw new RestException(400, 'Error: You must supply a description of the image you want to create');
		}
		
		if(!in_array($width, array(128, 256, 512, 768, 1024, 1792))){
			throw new RestException(400, 'Error: Width must be either 128, 256, 512, 768, or 1024');
		}
		
		if(!in_array($height, array(128, 256, 512, 768, 1024 ,1792))){
			throw new RestException(400, 'Error: Height must be either 128, 256, 512, 768, or 1024');
		}
		
		$finalPrompt = $prompt;
		if($style != NULL){
			$finalPrompt = $style . ' style, ' . $prompt . ', in the style of '. $style;
		}
			
		$userid = BasicAuth::getuserid();
		$user = BasicAuth::getuser();
		
		$versionNumber = floatval($appversion);
		if($user->credits <=0 && $user->lifetime <=0 && $user->awardedfreecredits == 0 && $versionNumber >= 3.1 && $freecreditsenabled == true){
		    $user->credits = 5;
		    $user->awardedfreecredits = 1;
		    R::store($user);
		    throw new RestException(403, 'You have been awarded 5 more credits for FREE.');
		}
		else if($user->credits <= 0 && $user->lifetime <= 0){
			throw new RestException(402, 'Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art.');
		}
		
		$ratelimit = R::load('ratelimit', 1);
		
		$ipaddress = getIP();
		$current = gmdate('Y-m-d H:i:s');
		$minuteago = new \DateTime($current, new DateTimeZone('UTC'));
		$minuteago->modify("-".$ratelimit->durationseconds." seconds");

		$logs = R::find('log', ' ipaddress = ? OR user_id = ? LIMIT 5 ', array($ipaddress, $userid));
		$count = 0;
		foreach($logs as $log){
			$logtime = new \DateTime($log->datetime, new DateTimeZone('UTC'));
			if($logtime > $minuteago){
				$count++;
			}
		}

		if($count >= $ratelimit->maxcalls){
			throw new RestException(429, 'Error: Too many requests');
		}
		
		//ok so now we can run the api
		/*$header = array();
		$header[] = 'Authorization: Token '. REPLICATE_API_TOKEN;
		$header[] = 'Content-type: application/json';

		//$headers = [ 'Authorization: Token '. REPLICATE_API_TOKEN];
		//$POST = ['version' => 'a9758cbfbd5f3c2094457d996681af52552901775aa2d6dd0b17fd15df959bef', 'input' => '{"prompt":"'.$prompt.'"}', 'webhook_completed' => 'https://myrestfulapi.com/endlessloopapps/aiartgenerator/api/predictioncompleted'];
		$data = ['version' => 'a9758cbfbd5f3c2094457d996681af52552901775aa2d6dd0b17fd15df959bef', 'input' => ['prompt' => $prompt, 'width' => $width, 'height' => $height, 'num_outputs' => $num_outputs], 'webhook_completed' => 'https://myrestfulapi.com/endlessloopapps/aiartgenerator/api/predictioncompleted'];
		$postdata = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "https://api.replicate.com/v1/predictions");
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		$response   = curl_exec($ch);*/
		
		
		/*
				{
		"error": {
		"code": null,
		"message": "Rate limit reached for images per minute. Limit: 20/1min. Current: 24/1min. Please visit https://help.openai.com/en/articles/6696591 to learn how to increase your rate limit.",
		"param": null,
		"type": "requests"
		},
		"id": "DALL-E_r5Oq871zVs2a9bRn6mzf9E"
		}
		*/
		
		
		$initialDelay = 1000; //1 second
		$maxRetries = 8;
		$maxDelay = 128000;
		$retries = 0;
		$delay = $initialDelay;
		

		$headers = [ 'Authorization: Bearer '. OPENAI_API_KEY, 'Content-Type: application/json'];
		
		if($dalleversion == 2){
    		$POST = '{"prompt": "' . $finalPrompt . '", "n": ' . $num_outputs . ', "size":  "'.$width.'x'.$height.'", "user": "'. $user->id . '"}';
    		$ch = curl_init();
    		curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/images/generations");
    		curl_setopt($ch, CURLOPT_POST, true);
    		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $POST);
    		$httpCode = 200;
    		
    		do {
    			$response   = curl_exec($ch);
    			//print($response);
    			
    			//stasrt new code
    			//might need to check 429 in json
    			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    			
    			// Check for 429 error
    			if ($httpCode == 429) {
    			  // Handle 429 error
    			  $retries++;
    			  $delay *= 2;
    			  $randomMS = rand(0, 1000);
    			  $delay += $randomMS;
    			  
    			  if($delay > $maxDelay){
    				$delay = $maxDelay;
    			  }
    			  
    			  /*$file_handle = fopen('retry.txt', 'a');
    			 fwrite($file_handle, "retry count: " . $retries . " - delay: " . $delay . "\r\n");
    			 fclose($file_handle);*/
    			  
    			  $finaldelay = $delay * 1000;
    			  usleep($finaldelay);
    			  
    			}
    
    		} while($httpCode == 429 && $retries < $maxRetries);
    
    		$status = "succeeded";
    		$errormessage = "";
    		
    		if($httpCode == 429) {
    			$status = "failed";
    			$errormessage = "429: Too many requests";
    		}
    		else if($response === false || $httpCode != 200){
    			//we have an error
    			$status = "failed";
    			$errormessage = curl_error($ch);
    		}
    		
    		curl_close($ch);
		}
		else if($dalleversion == 3){
		    $num_outputs = 1;
            //$width = 1024;
            //$height = 1024;
            $model = "dall-e-3";
            
		    $postData = [
                //"quality" => "hd",
                "model" => $model,
                "prompt" => $finalPrompt,
                "n" => $num_outputs,
                "size" => $width . 'x' . $height,
                "user" => $user->id
            ];

		   $POST = json_encode($postData);
    		$ch = curl_init();
    		curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/images/generations");
    		curl_setopt($ch, CURLOPT_POST, true);
    		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    		curl_setopt($ch, CURLOPT_POSTFIELDS, $POST);
    		$httpCode = 200;
    		
    		do {
    			$response   = curl_exec($ch);
    			//print($response);
    			
    			//stasrt new code
    			//might need to check 429 in json
    			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    			
    			// Check for 429 error
    			if ($httpCode == 429) {
    			  // Handle 429 error
    			  $retries++;
    			  $delay *= 2;
    			  $randomMS = rand(0, 1000);
    			  $delay += $randomMS;
    			  
    			  if($delay > $maxDelay){
    				$delay = $maxDelay;
    			  }
    			  
    			  /*$file_handle = fopen('retry.txt', 'a');
    			 fwrite($file_handle, "retry count: " . $retries . " - delay: " . $delay . "\r\n");
    			 fclose($file_handle);*/
    			  
    			  $finaldelay = $delay * 1000;
    			  usleep($finaldelay);
    			  
    			}
    
    		} while($httpCode == 429 && $retries < $maxRetries);
    
    		$status = "succeeded";
    		$errormessage = "";
    		
    		if($httpCode == 429) {
    			$status = "failed";
    			$errormessage = "429: Too many requests";
    		}
    		else if($response === false || $httpCode != 200){
    			//we have an error
    			$status = "failed";
    			$errormessage = curl_error($ch);
    		}
    		
    		curl_close($ch);
		}
		
/*
{
  "created": 1667850415,
  "data": [
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-Ywi0xM7wlCZv6m98RH4gFTfX.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=rqocyelnVkmv1FjjcOsI1Rg2czUBHmkeAwnAU55iV8s%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-5satOwdtLIq4cS6S1IZ8ezX3.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=Hp/T3zWFkyB1O8QS1Oz5qw6OOuu%2BpXnwU3T%2BddLaoL0%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-xIdfzuA0s6k88OP6aEiJ1J1g.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=lP4dJCGhKudl/spMJJNyDaYseJGNrJcARswfxAI71pA%3D"
    },
    {
      "url": "https://oaidalleapiprodscus.blob.core.windows.net/private/org-VPv6QyxgyqKUg5NVqywRYrtM/user-4iPMgcq9SPXwZuO6kjt3pgJc/img-3clrk1nzU3NCEdLmOSHCPXi9.png?st=2022-11-07T18%3A46%3A55Z&se=2022-11-07T20%3A46%3A55Z&sp=r&sv=2021-08-06&sr=b&rscd=inline&rsct=image/png&skoid=6aaadede-4fb3-4698-a8f6-684d7786b067&sktid=a48cca56-e6da-484e-a814-9c849652bcb3&skt=2022-11-07T01%3A10%3A03Z&ske=2022-11-08T01%3A10%3A03Z&sks=b&skv=2021-08-06&sig=sns9/q4RGPkldvDHh%2BG5IsCY2%2B7hz/jpHS4bUq8A2wo%3D"
    }
  ]
}





{
"error": {
"code": 402,
"message": "Payment Required: Error: You have run out of credits. Consider upgrading to lifetime to generate unlimited art."
}
}
*/




		//take json response parse it and store in database
		//var_dump($response);
		/*
		$file_handle = fopen('generateresponse.json', 'w');
		fwrite($file_handle, $response);
		fclose($file_handle);
		*/
		
		$newlog = R::dispense('log');
		$newlog->ipaddress = $ipaddress;
		$newlog->content = $prompt;
		$newlog->style = $style;
		$newlog->width = $width;
		$newlog->height = $height;
		$newlog->datetime = gmdate('Y-m-d H:i:s');
		$user->ownLogList[] = $newlog;
		
		
		$obj = json_decode($response);
		
		
		
		if(isset($obj->error)){
			$status = "failed";
			$errormessage = $obj->error->message;
		}
		
	
		$prediction = R::dispense('prediction');
		$predictionid = "DALL-E_".randString(22, "mixed", "");
		$prediction->predictionid = $predictionid;
		$prediction->prompt = $prompt;
		$prediction->style = $style;
		$prediction->numoutputs = $num_outputs;
		$prediction->status = $status;		
		$prediction->errormessage = $errormessage;
		$prediction->version = "v1";
		$prediction->type = $gentype;
		$prediction->model = "dalle" . $dalleversion;
		
		if(isset($obj->data)){
			if(count($obj->data) > 0){
				$prediction->output = $obj->data[0]->url;
			}
			
			if(count($obj->data) > 1){
				$prediction->output2 = $obj->data[1]->url;
			}
			
			if(count($obj->data) > 2){
				$prediction->output3 = $obj->data[2]->url;
			}
			
			if(count($obj->data) > 3){
				$prediction->output4 = $obj->data[3]->url;
			}
		}
		
		//$prediction->geturl = $obj->urls->get;
		//$prediction->cancelurl = $obj->urls->cancel;
		
		
		
		$user->ownPredictionList[] = $prediction;
		
		if($user->lifetime <= 0){
		    $credits = $user->credits - 1;
	    	if($credits < 0) $credits = 0;
		    $user->credits = $credits;
		}
		
		R::store($user);
		$obj->id = $predictionid;
		$obj->pid = $prediction->id;
		return $obj;
    }
    
	protected function get() {
		
		throw new RestException(501, 'GET not implemented');
	}
    
}
?>