<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class poll {
    //public $db;
    function __construct() {

    }
    
    function isFirstQuestion($poll_id, $question_id) {
        $firstQuestion = R::getRow('SELECT * FROM pollquestion WHERE poll_id = ? ORDER BY sortorder ASC, id ASC LIMIT 1', [$poll_id]);
    
        return $firstQuestion && $firstQuestion['question_id'] == $question_id;
    }
    
    function isLastQuestion($poll_id, $question_id) {
        $lastQuestion = R::getRow('SELECT * FROM pollquestion WHERE poll_id = ? ORDER BY sortorder DESC, id DESC LIMIT 1', [$poll_id]);
    
        return $lastQuestion && $lastQuestion['question_id'] == $question_id;
    }
    
    /**
     * Validates the existence of user and throws exception if not found.
     */
    private function validateUser($user) {
        if (!$user) {
            throw new RestException(400, 'Error: User account not found.');
        }
    }

    /**
     * Validates required inputs and throws an exception if any are missing.
     */
    private function validateInputs($inputs) {
        foreach ($inputs as $key => $value) {
            if (!$value) {
                throw new RestException(400, "Error: $key must be supplied.");
            }
        }
    }
        
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    private function validateFriendExists($friend_id, $poll_id) {
        $friendExists = R::findOne('user', 'id = ?', [$friend_id]);
        if (!$friendExists) {
            AppLogger::logError("[poll]: friend was not found vote skipped: ", [
                'firebaseuserid' => $firebaseuserid,
                'pollid' => $poll_id,
                'friendid' => $friend_id
                  ]);
                  
            throw new Exception('Friend does not exist, vote skipped.');
        }
    }
    
    private function recordResponse($userid, $user, $question_id, $poll_question_id, $friend_id, $option1, $option2, $option3, $option4) {
    
        $response = R::dispense('response');
        $response->user_id = $userid;
        $response->gender_id = $user->gender_id;
        $response->grade = $user->grade;
        $response->question_id = $question_id;
        $response->poll_question_id = $poll_question_id;
        $response->selected_friend_id = $friend_id;
        $response->option1 = $option1;
        $response->option2 = $option2;
        $response->option3 = $option3;
        $response->option4 = $option4;
        R::store($response);
    }
    
    private function fetchOrCreateUserPoll($userid, $poll, $question_id) {
    
        $poll_id = $poll->id;
        $userpoll = R::findOne('userpoll', ' user_id = ? AND poll_id = ? ', array($userid, $poll_id));
        
        if(!$userpoll){
            $userpoll = R::dispense('userpoll');
            $userpoll->user_id = $userid;
            $userpoll->poll_id = $poll_id;
            
             AppLogger::logError("[poll]: userpoll was not found, this should not happen: ", [
            'firebaseuserid' => $firebaseuserid,
            'questionid' => $question_id,
            'pollid' => $poll_id
              ]);
        }
        
        $userpoll->last_question_id = $question_id;
        
        
        if ($question_id == $poll->last_question_id) {
            $userpoll->completed = true; 
            $userpoll->end_time = gmdate("Y-m-d H:i:s");
        }

        R::store($userpoll);
        return $userpoll;
    }
    
    private function fetchNextQuestionAnswers($nextQuestion, $userid) {
      if ($nextQuestion) {
          $visibilityBoost = R::getRow("SELECT id, user_id FROM visibilityboost WHERE target_user_id = ? AND applied = 0 LIMIT 1", [$userid]);

            $totalFriendsCount = R::getCell("SELECT COUNT(*) FROM friendship WHERE user_id = ?", [$userid]);
            $offset = $totalFriendsCount > 200 ? rand(0, $totalFriendsCount - 200) : 0;
            $friendIDs = R::getCol("
                SELECT 
                    u.id
                FROM 
                    friendship AS f
                JOIN 
                    user AS u ON f.friend_id = u.id
                WHERE 
                    f.user_id = ?
                LIMIT 200 OFFSET ?", 
                [$userid, $offset]);
          

           $selectedFriends = [];
            if (!empty($friendIDs)) {
                $selectedFriendIDs = (count($friendIDs) > 4) ? array_rand(array_flip($friendIDs), 4) : $friendIDs;
                $selectedFriends = R::getAll("SELECT u.id as friend_id, u.first_name, u.last_name, COALESCE(rq.response_count, 0) as response_count
                                                FROM user AS u
                                                LEFT JOIN responsecount rq ON rq.friend_id = u.id AND rq.question_id = ?
                                                WHERE u.id IN (" . implode(',', $selectedFriendIDs) . ")",
                                                [$nextQuestion['id']]);
            }

            // Include boost friend if applicable
            if (!empty($visibilityBoost)) {
                
                $boostFriendDetails = R::getRow("SELECT u.id as friend_id, u.first_name, u.last_name 
                                                FROM user AS u
                                                WHERE u.id = ?", [$visibilityBoost['user_id']]);
                array_unshift($selectedFriends, $boostFriendDetails);
                // Mark visibility boost as applied
                R::exec("UPDATE visibilityboost SET applied = 1 WHERE id = ?", [$visibilityBoost['id']]);
            }

          
          
            $nextQuestion['answers'] = $selectedFriends;
    
        } else {
            //there is no next question so...
        }
            
        return $nextQuestion;
    }
    
    private function fetchNextQuestion($userid, $poll, $currentQuestionID) {
        $nextQuestion = [];
    
        if ($poll) {
            $pollID = $poll['id'];
            
            // Get the sort order of the current question
            $currentSortOrder = R::getCell(
                "SELECT sortorder FROM pollquestion WHERE question_id = ? AND poll_id = ?",
                [$currentQuestionID, $pollID]
            );
    
            // Check if currentSortOrder is not null, then proceed to get the next question
            if ($currentSortOrder !== null) {
                // Fetch the next question based on the sort order
                $nextQuestionSQL = "
                    SELECT pq.question_id, pq.id AS poll_question_id, q.id, q.text, q.emoji, pq.sortorder
                    FROM pollquestion AS pq
                    JOIN question AS q ON pq.question_id = q.id
                    WHERE pq.poll_id = ? AND pq.sortorder > ?
                    ORDER BY pq.sortorder ASC
                    LIMIT 1";
    
                $nextQuestion = R::getRow($nextQuestionSQL, [$pollID, $currentSortOrder]);
            } else {
                // If we don't have a current sort order, then this user has not answered any question yet,
                // so we fetch the first question.
                $nextQuestionSQL = "
                    SELECT pq.question_id, pq.id AS poll_question_id, q.id, q.text, q.emoji, pq.sortorder
                    FROM pollquestion AS pq
                    JOIN question AS q ON pq.question_id = q.id
                    WHERE pq.poll_id = ?
                    ORDER BY pq.sortorder ASC
                    LIMIT 1";
    
                $nextQuestion = R::getRow($nextQuestionSQL, [$pollID]);
            }
        }
    
        return $nextQuestion;
    }

        
    protected function put($poll_id, $friend_id, $question_id, $poll_question_id,$option1, $option2, $option3, $option4) {
        
        try{
            
            R::begin();
            $firebaseuserid = BasicAuth::getfirebaseuserid();
            $userid = BasicAuth::getuserid();
            $user = BasicAuth::getuser();
            
            $responses = [];
            $this->validateUser($user);
            $this->validateInputs(compact('firebaseuserid', 'poll_id', 'question_id', 'friend_id', 'poll_question_id', 'option1', 'option2', 'option3', 'option4'));
            $this->validateFriendExists($friend_id, $poll_id);

            $this->recordResponse($userid, $user, $question_id, $poll_question_id, $friend_id, $option1, $option2, $option3, $option4);

            
            $poll = R::load('poll', $poll_id);
            if (!$poll->id) {
                throw new Exception('Poll does not exist.');
            }
            
            $userpoll = $this->fetchOrCreateUserPoll($userid, $poll, $question_id);
            
            $nextQuestion = [];
     
        
            if($userpoll->completed == false) {
                $nextQuestion = $this->fetchNextQuestion($userid, $poll, $question_id);
                
               if ($nextQuestion) {
                    $nextQuestion = $this->fetchNextQuestionAnswers($nextQuestion, $userid);
                }
            }
            

            R::commit();
            return ['status' => 'success', 'responses' => $responses, 'poll_completed' => $userpoll->completed, 'poll_id' => $poll_id, 'nextquestion' => $nextQuestion];
        } catch (Exception $e) {
            R::rollback();
             AppLogger::logError("[poll]: General error in post method: " . $e->getMessage(), [
                'firebaseuserid' => $firebaseuserid
                  ]);
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
                    
    }
    
    protected function post($poll_id, $last_question_id){
        
        try {
            $firebaseuserid = BasicAuth::getfirebaseuserid();
            $userid = BasicAuth::getuserid();
            $user = BasicAuth::getuser();
    
            // Attempt to find an existing poll
            try {
                $existingPoll = R::findOne('userpoll', 'user_id = ? AND completed = 0 ORDER BY id DESC LIMIT 1', [$userid]);
    
                if ($existingPoll) {
                    $existingPoll->last_question_id = $last_question_id;
                    if($this->isLastQuestion($poll_id, $last_question_id)){
                        $existingPoll->end_time = gmdate("Y-m-d H:i:s");
                        $existingPoll->completed = 1; 
                    }
                    R::store($existingPoll);
                    return $existingPoll;
                }
            } catch (Exception $e) {
                // Log error for existing poll processing
                AppLogger::logError("[poll]: Error updating existing poll: " . $e->getMessage(), [
                    'firebaseuserid' => $firebaseuserid,
                    'poll_id' => $poll_id,
                    'last_question_id' => $last_question_id
                ]);
            }
    
            // If no existing poll, create a new one
            try {
                $newPoll = R::dispense('userpoll');
                $newPoll->user_id = $userid;
                $newPoll->poll_id = $poll_id;
                $newPoll->start_time = gmdate("Y-m-d H:i:s");
                $newPoll->end_time = NULL;
                $newPoll->completed = 0;
                $newPoll->last_question_id = $last_question_id;
                $newPoll->active = 1;
                R::store($newPoll);
                return $newPoll;
            } catch (Exception $e) {
                // Log error for new poll creation
                AppLogger::logError("[poll]: Error creating new poll: " . $e->getMessage(), [
                    'firebaseuserid' => $firebaseuserid,
                    'poll_id' => $poll_id,
                    'last_question_id' => $last_question_id
                ]);
                throw new RestException(500, "An error occurred while processing the poll.");
            }
        } catch (Exception $e) {
            // General catch block for other unexpected errors
            AppLogger::logError("[poll]: General error in post method: " . $e->getMessage(), [
                'firebaseuserid' => $firebaseuserid
            ]);
            throw new RestException(500, "An error occurred while processing the request.");
        }
        /*$firebaseuserid = BasicAuth::getfirebaseuserid();
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
    
        $existingPoll = R::findOne('userpoll', 'user_id = ? AND completed = 0 ORDER BY id DESC LIMIT 1', [$userid]);
    
        $returnPoll = NULL;
        if ($existingPoll) {
            $existingPoll->last_question_id = $last_question_id;
            if($this->isLastQuestion($poll_id, $last_question_id)){
                $existingPoll->end_time = gmdate("Y-m-d H:i:s"); 
                $existingPoll->completed = 1;
            }
            R::store($existingPoll);
            $returnPoll = $existingPoll;
        } else {
            $newPoll = R::dispense('userpoll');
            $newPoll->user_id = $userid;
            $newPoll->poll_id = $poll_id;
            $newPoll->start_time = gmdate("Y-m-d H:i:s");
            $newPoll->end_time = NULL; 
            $newPoll->completed = 0;
            $newPoll->last_question_id = $last_question_id;
            $newPoll->active = 1;
            R::store($newPoll);
            $returnPoll = $newPoll;
        }
    
        return $returnPoll;*/
    }
    
    //get the current userpoll
    //if doesn't exist or is completed create new one
    //grab the current question we need to show them
    //return the data and question information to client
    
    protected function get() {
        $firebaseuserid = BasicAuth::getfirebaseuserid();
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();

        $nextPollSQL = "
            SELECT p.* FROM poll AS p
            WHERE p.id > IFNULL((
                SELECT up.poll_id FROM userpoll AS up
                WHERE up.user_id = ? AND up.completed = 1
                ORDER BY up.poll_id DESC
                LIMIT 1
            ), 0)
            ORDER BY p.id ASC
            LIMIT 1";

        $poll = R::getRow($nextPollSQL, [$userid]);

        if (!$poll) {
            $poll = R::getRow('SELECT * FROM poll ORDER BY id ASC LIMIT 1');
        }

        if ($poll) {
            $pollID = $poll['id'];
            $questionsSQL = "
                SELECT pq.question_id, pq.id AS poll_question_id, q.id, q.text, q.emoji, pq.sortorder
                FROM pollquestion AS pq
                JOIN question AS q ON pq.question_id = q.id
                WHERE pq.poll_id = ?
                ORDER BY pq.sortorder ASC";

            $questions = R::getAll($questionsSQL, [$pollID]);

            $visibilityBoost = R::getRow("SELECT id, user_id FROM visibilityboost WHERE target_user_id = ? AND applied = 0 LIMIT 1", [$userid]);

            $totalFriendsCount = R::getCell("SELECT COUNT(*) FROM friendship WHERE user_id = ?", [$userid]);
            $offset = $totalFriendsCount > 200 ? rand(0, $totalFriendsCount - 200) : 0;
            $friendIDs = R::getCol("
                SELECT 
                    u.id
                FROM 
                    friendship AS f
                JOIN 
                    user AS u ON f.friend_id = u.id
                WHERE 
                    f.user_id = ?
                LIMIT 200 OFFSET ?", 
                [$userid, $offset]);

            foreach ($questions as $key => $question) {
                // Fetch selected friends
                $selectedFriends = [];
                if (!empty($friendIDs)) {
                    $selectedFriendIDs = (count($friendIDs) > 4) ? array_rand(array_flip($friendIDs), 4) : $friendIDs;
                    $selectedFriends = R::getAll("SELECT u.id as friend_id, u.first_name, u.last_name, COALESCE(rq.response_count, 0) as response_count
                                                    FROM user AS u
                                                    LEFT JOIN responsecount rq ON rq.friend_id = u.id AND rq.question_id = ?
                                                    WHERE u.id IN (" . implode(',', $selectedFriendIDs) . ")",
                                                    [$question['id']]);
                }
    
                // Include boost friend if applicable
                if (!empty($visibilityBoost)) {
                    
                    $boostFriendDetails = R::getRow("SELECT u.id as friend_id, u.first_name, u.last_name 
                                                    FROM user AS u
                                                    WHERE u.id = ?", [$visibilityBoost['user_id']]);
                    array_unshift($selectedFriends, $boostFriendDetails);
                    // Mark visibility boost as applied
                    R::exec("UPDATE visibilityboost SET applied = 1 WHERE id = ?", [$visibilityBoost['id']]);
                }
    
                $questions[$key]['friends'] = $selectedFriends;
            }

        $poll['questions'] = $questions;
    }

    return $poll;
}

    
/*
//works but inefficient becuase it querys for friends for each question.
protected function get() {
    $userid = BasicAuth::getuserid();

    // Find the next or first poll
    $nextPollSQL = "
        SELECT p.* FROM poll AS p
        WHERE p.id > IFNULL((
            SELECT up.poll_id FROM userpoll AS up
            WHERE up.user_id = ? AND up.completed = 1
            ORDER BY up.poll_id DESC
            LIMIT 1
        ), 0)
        ORDER BY p.id ASC
        LIMIT 1";

    $poll = R::getRow($nextPollSQL, [$userid]);

    if (!$poll) {
        $poll = R::getRow('SELECT * FROM poll ORDER BY id ASC LIMIT 1');
    }

    if ($poll) {
        $pollID = $poll['id'];
        $questionsSQL = "
            SELECT pq.id AS poll_question_id, q.id, q.text, q.emoji, pq.sortorder
            FROM pollquestion AS pq
            JOIN question AS q ON pq.question_id = q.id
            WHERE pq.poll_id = ?
            ORDER BY pq.sortorder ASC";

        $questions = R::getAll($questionsSQL, [$pollID]);

        // Check for a visibility boost
        $visibilityBoost = R::getRow("SELECT friend_id FROM visibilityboost WHERE target_user_id = ? AND applied = 0 LIMIT 1", [$userid]);

       foreach ($questions as $key => $question) {
            // Fetch the total count of friends
            $totalFriendsCount = R::getCell("SELECT COUNT(*) FROM friendship WHERE user_id = ?", [$userid]);
            
            // Calculate a random offset based on the total count
            $offset = $totalFriendsCount > 100 ? rand(0, $totalFriendsCount - 100) : 0;

            // Fetch friends using the calculated offset
            $friendsSQL = "SELECT 
                                u.id as friend_id, 
                                u.first_name, 
                                u.last_name,
                                COALESCE(rq.response_count, 0) as response_count
                           FROM 
                                friendship AS f
                           JOIN 
                                user AS u ON f.friend_id = u.id
                           LEFT JOIN 
                                responsecount rq ON rq.friend_id = u.id AND rq.question_id = ?
                           WHERE 
                                f.user_id = ?
                           LIMIT 100 OFFSET ?;";
            $potentialFriends = R::getAll($friendsSQL, [$question['id'], $userid, $offset]);

            // Shuffle and select the desired number of friends
            shuffle($potentialFriends);
            $friendsLimit = isset($visibilityBoost) && $key === $boostQuestionKey ? 3 : 4;
            $selectedFriends = array_slice($potentialFriends, 0, $friendsLimit);

            // Handle visibility boost friend inclusion
            if (isset($visibilityBoost) && ($key === $boostQuestionKey)) {
                $boostFriendIncluded = false;
                foreach ($selectedFriends as $friend) {
                    if ($friend['friend_id'] == $visibilityBoost['friend_id']) {
                        $boostFriendIncluded = true;
                        break;
                    }
                }
                if (!$boostFriendIncluded) {
                    $boostFriendDetails = R::getRow("SELECT u.id as friend_id, u.first_name, u.last_name 
                                                    FROM user AS u
                                                    WHERE u.id = ?", [$visibilityBoost['friend_id']]);
                    array_pop($selectedFriends); // Remove one friend to make room for the boost friend
                    array_unshift($selectedFriends, $boostFriendDetails); // Add boost friend to the beginning

                    // Mark visibility boost as applied
                    R::exec("UPDATE visibilityboost SET applied = 1 WHERE friend_id = ?", [$visibilityBoost['friend_id']]);
                }
            }

            $questions[$key]['friends'] = $selectedFriends;
        }

        $poll['questions'] = $questions;
    }

    return $poll;
}*/

    
    /*protected function get() {
        $userid = BasicAuth::getuserid();
        
        // Attempt to find the next poll in one go
        $nextPollSQL = "
            SELECT p.* FROM poll AS p
            WHERE p.id > IFNULL((
                SELECT up.poll_id FROM userpoll AS up
                WHERE up.user_id = ? AND up.completed = 1
                ORDER BY up.poll_id DESC
                LIMIT 1
            ), 0)
            ORDER BY p.id ASC
            LIMIT 1";
            
        $poll = R::getRow($nextPollSQL, [$userid]);
    
        // If no next poll is found, attempt to get the first poll
        if (!$poll) {
            $poll = R::getRow('SELECT * FROM poll ORDER BY id ASC LIMIT 1');
        }
    
        if ($poll) {
            // Directly fetch questions with a more complex query if needed
            $pollID = $poll['id']; // Assuming 'id' is the poll ID in the result set
            $questionsSQL = "
                SELECT pq.id AS poll_question_id, q.id, q.text, q.emoji, pq.sortorder
                FROM pollquestion AS pq
                JOIN question AS q ON pq.question_id = q.id
                WHERE pq.poll_id = ?
                ORDER BY pq.sortorder ASC";
                
            $questions = R::getAll($questionsSQL, [$pollID]);
            $poll['questions'] = $questions; // Attach questions directly to the poll array
        }
    
        return $poll;
    }
*/
    
    /*protected function get() {
    	
    	$userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
        $lastCompletedPoll = R::findOne('userpoll', ' user_id = ? AND completed = ? ORDER BY poll_id DESC', [$userid, 1]);

        $poll = null;
        if ($lastCompletedPoll) {
            $poll = R::findOne('poll', ' id > ? ORDER BY id ASC LIMIT 1', [$lastCompletedPoll->poll_id]);
        }
    
        if (!$poll) {
            $poll = R::findOne('poll', ' ORDER BY id ASC LIMIT 1');
        }
    
        if ($poll) {
            $questions = R::findAll('pollquestion', ' poll_id = ? ORDER BY `sortorder` ASC', [$poll->id]);
            
              $formattedQuestions = [];
            foreach ($questions as $question) {
                $formattedQuestions[] = [
                    'poll_question_id' => $question->id,
                    'id' => $question->question->id,
                    'text' => $question->question->text, 
                    'emoji' => $question->question->emoji, 
                    'order' => $question->sortorder 
                ];
            }
            
          
            $poll->questions = $formattedQuestions;
        }

    return $poll; 
    }*/
}
?>