<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class inbox {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    private function validateInputs($user, $response_id, $inbox_id) {
        if (!$user) {
            throw new RestException(400, 'Error: User not found');
        }
        if (!$response_id) {
            throw new RestException(400, 'Error: Response ID must be supplied');
        }
        if (!$inbox_id) {
            throw new RestException(400, 'Error: Inbox ID must be supplied');
        }
    }

    protected function put($response_id, $inbox_id, $fullname=0) {
        $user = BasicAuth::getuser();
        
         $this->validateInputs($user, $response_id, $inbox_id);
    
    
        if ($user->reveal_count <= 0 && $fullname == 1) {
            return ['status' => 'error', 'message' => 'Insufficient reveal credits.'];
        }
         
         $retobj = new stdClass();
          
         R::begin();
         
         try{
             $response = R::findOne('response', ' id = ? AND selected_friend_id = ? ', [$response_id, $user->id]);
             $inbox = R::findOne('inbox', ' id = ? AND user_id = ? ', [$inbox_id, $user->id]);
             $reveal_user = R::findOne('user', ' id = ? ', [$response->user_id]);
             
             if($response && $inbox && $reveal_user) {
                 
                  AppLogger::logError("[inbox]: Error: ", ['firstname' => $reveal_user->first_name, 'action' => $reveal_user->id]);
                 
                 $full_name = $reveal_user->first_name . " " . $reveal_user->last_name; 
                 
                 if($fullname == 1){
                     if($response->name_revealed == 0){
                          $user->reveal_count = $user->reveal_count - 1;
                          R::store($user);
                     }
                     
                     $response->name_revealed = 1;
                     $inbox->name_revealed = 1;
                     $inbox->full_name = $full_name;
                     
                     $retobj->full_name = $full_name; 
                     $retobj->message = "Successfully revealed full name";
                 }
                 else {
                      $inbox->first_letter = $full_name;
                      $retobj->first_letter = substr($full_name,0,1); 
                       $retobj->reveal_count = $user->reveal_count;
                       $retobj->message = "Successfully revealed first letter";
                 }
                
                 $retobj->status = "success";
                
                 R::store($response);
                 R::store($inbox);
             }
             else{ 
                 $retobj->status =  "error";
                 $retobj->message = "Could not find response";
             }
             
             R::commit();
         } catch (Exception $e) {
             R::rollback();    
             return ['status' => 'error', 'message' => "Failed to update response record: " . $e->getMessage()];
         }
          
          return $retobj;
    }
    
    function getUnreadCount($user){
     return R::count('inbox', ' user_id = ? AND unread = ? ', [$user->id, 1]);
    }
    
    protected function post(){
        $user = BasicAuth::getuser();
        
         if (!$user) {
            throw new RestException(400, 'Error: User not found');
        }
       
       
        
        $retobj = new stdClass();
         
       $unreadCount = $this->getUnreadCount($user);
        
        $retobj = new stdClass();
        $retobj->status = "success";
        $retobj->unreadCount = $unreadCount;
    
        return $retobj;
    }
    
    protected function handleSpecialTeamYaaasResponse($user) {
        $retobj = new stdClass();
        $retobj->status = "success";
    
        $star = new stdClass();
        $star->grade = "12";
        $star->selected_friend_id = "1";
        $star->hide_activity_feed = "0";
    
        // All options named "Team YAAAS"
        $star->option1_name = $star->option2_name = $star->option3_name = $star->option4_name = "Team YAAAS";
    
        // Always select the first option
        $star->selected_option_index = 1; // +1 to make index 1-based
    
        $star->gender_slang = "girl";
        $star->gender = "female";
    
        $star->question_text = "";
        $star->question_emoji = "";
        $star->friend_name = "Team YAAAS";
        $star->anonymous = "0";
    
        // Get unread count
        $star->unreadCount = $this->getUnreadCount($user);
    
        // Update inbox status
        $inbox = R::findOne('inbox', ' response_id = ? AND user_id = ? ', [1, $user->id]);
        if ($inbox) {
            $inbox->unread = 0;
            R::store($inbox);
        }
    
        $retobj->responses = $star;
    
        return $retobj;
    }

    
   protected function get($response_id=null){
         $user = BasicAuth::getuser();
        
         if (!$user) {
            throw new RestException(400, 'Error: User not found');
         }
         
         if($response_id == 1) {
            return $this->handleSpecialTeamYaaasResponse($user);
         }
         else if ($response_id != null) { // Requesting specific response
            // Fetch response, user data, and question data in one optimized query
            $sql = "
                SELECT r.*, 
                       u1.first_name AS u1_first_name, u1.last_name AS u1_last_name,
                       u2.first_name AS u2_first_name, u2.last_name AS u2_last_name,
                       u3.first_name AS u3_first_name, u3.last_name AS u3_last_name,
                       u4.first_name AS u4_first_name, u4.last_name AS u4_last_name,
                       u0.first_name AS responder_first_name, u0.last_name AS responder_last_name,  -- These are the first and last names of the responder
                       g.slang AS gender_slang, g.gender AS gender,
                       q.text AS question_text, q.emoji AS question_emoji, r.hide_activity_feed, r.anonymous
                FROM response r
                LEFT JOIN user u1 ON r.user_option1_id = u1.id
                LEFT JOIN user u2 ON r.user_option2_id = u2.id
                LEFT JOIN user u3 ON r.user_option3_id = u3.id
                LEFT JOIN user u4 ON r.user_option4_id = u4.id
                LEFT JOIN user u0 ON r.user_id = u0.id  -- This joins the user table to get the responder's name
                LEFT JOIN gender g ON r.gender_id = g.id
                LEFT JOIN question q ON r.question_id = q.id
                WHERE r.id = ? AND r.selected_friend_id = ?
            ";

            $response = R::getRow($sql, [$response_id, $user->id]);
        
            if ($response) {
                $retobj = new stdClass();
                $retobj->status = "success";
                
                
                $star = new stdClass();
                $star->grade = $response['grade'];
                $star->selected_friend_id = $response['selected_friend_id'];
                $star->hide_activity_feed = $response['hide_activity_feed'];
                
                // Assign names using the retrieved data
                $star->option1_name = $response['u1_first_name'] . " " . $response['u1_last_name'];
                $star->option2_name = $response['u2_first_name'] . " " . $response['u2_last_name'];
                $star->option3_name = $response['u3_first_name'] . " " . $response['u3_last_name'];
                $star->option4_name = $response['u4_first_name'] . " " . $response['u4_last_name'];
                
                // Determine the selected option index
                $selectedOptions = [$response['user_option1_id'], $response['user_option2_id'], $response['user_option3_id'], $response['user_option4_id']];
                $star->selected_option_index = array_search($response['selected_friend_id'], $selectedOptions) + 1; // +1 to make index 1-based
                
                // Access gender slang and gender directly
                $star->gender_slang = $response['gender_slang'];
                $star->gender = $response['gender'];
        
                // Add question details
                $star->question_text = $response['question_text'];
                $star->question_emoji = $response['question_emoji'];
                
                $star->friend_name = $response['responder_first_name'] . " " . $response['responder_last_name'];
                $star->anonymous = $response['anonymous'];
                
                $inbox = R::findOne('inbox', ' response_id = ? AND user_id = ? ', [$response_id, $user->id]);
                if($inbox){
                    $inbox->unread = 0;
                    R::store($inbox);
                }
                
                $unreadCount = $this->getUnreadCount($user);
                $star->unreadCount = $unreadCount;
                
                // Add the constructed star object to the return object
                $retobj->responses = $star;
                return $retobj;
            } else {
                // Could not find any results
                throw new RestException(500, 'Error: Could not find a response');
            }
        }
        else{ //requesting list of inbox items
        
            // SQL to join inbox with gender table and fetch required fields
            $sql = "SELECT i.*, g.slang AS gender_slang, g.gender AS gender_name
                    FROM inbox i
                    LEFT JOIN gender g ON i.gender_id = g.id
                    WHERE i.user_id = ?
                    ORDER BY i.id DESC";
            
            // Execute the query with the user ID
            $responses = R::getAll($sql, [$user->id]);
        
            $retobj = new stdClass();
            $retobj->status = "success";
            $retobj->responses = $responses;
            return $retobj;
         }
    }
}
?>