<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class friendsuggestions {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    function post(){
        throw new RestException(501, 'POST not implemented');
    }
    
    protected function get() {
        
        try {
                $firebaseuserid = BasicAuth::getfirebaseuserid();
                $userid = BasicAuth::getuserid();
                $user = BasicAuth::getuser();
                
                $retobj = new stdClass();
                
                $queryMayKnow = "SELECT other_users.id AS userid, other_users.first_name, other_users.last_name, other_users.username AS username, other_users.photo_url, COUNT(DISTINCT mutual_contacts.id) AS mutualfriendscount,
                                CASE WHEN f.user_id IS NOT NULL THEN 1 ELSE 0 END AS friendship
                                FROM user AS given_user 
                                JOIN contact AS given_user_contacts ON given_user.id = given_user_contacts.user_id 
                                JOIN contactphonenumber AS given_user_phonenumbers ON given_user_contacts.id = given_user_phonenumbers.contact_id 
                                JOIN contactphonenumber AS mutual_contacts_phonenumbers ON given_user_phonenumbers.number = mutual_contacts_phonenumbers.number 
                                JOIN contact AS mutual_contacts ON mutual_contacts_phonenumbers.contact_id = mutual_contacts.id 
                                JOIN user AS other_users ON mutual_contacts.user_id = other_users.id 
                                LEFT JOIN friendship f ON other_users.id = f.friend_id AND f.user_id = :user_id
                                WHERE given_user.id = :user_id AND other_users.id != :user_id
                                AND NOT EXISTS (
                                    SELECT 1
                                    FROM contact c
                                    JOIN contactphonenumber cp ON c.id = cp.contact_id
                                    WHERE cp.number = other_users.phone_number AND c.user_id = :user_id
                                )
                                GROUP BY other_users.id, other_users.username 
                                ORDER BY mutualfriendscount DESC;";

                // Query for people you may know, excluding direct friends
                /*$queryMayKnow = "SELECT other_users.id AS userid, other_users.first_name, other_users.last_name, other_users.username AS username, other_users.photo_url, COUNT(DISTINCT mutual_contacts.id) AS mutualfriendscount 
                                FROM user AS given_user 
                                JOIN contact AS given_user_contacts ON given_user.id = given_user_contacts.user_id 
                                JOIN contactphonenumber AS given_user_phonenumbers ON given_user_contacts.id = given_user_phonenumbers.contact_id 
                                JOIN contactphonenumber AS mutual_contacts_phonenumbers ON given_user_phonenumbers.number = mutual_contacts_phonenumbers.number 
                                JOIN contact AS mutual_contacts ON mutual_contacts_phonenumbers.contact_id = mutual_contacts.id 
                                JOIN user AS other_users ON mutual_contacts.user_id = other_users.id 
                                WHERE given_user.id = :user_id AND other_users.id != :user_id
                                AND NOT EXISTS (
                                    SELECT 1
                                    FROM contact c
                                    JOIN contactphonenumber cp ON c.id = cp.contact_id
                                    WHERE cp.number = other_users.phone_number AND c.user_id = :user_id
                                )
                                GROUP BY other_users.id, other_users.username 
                                ORDER BY mutualfriendscount DESC;";*/
                
                $paramsMayKnow = ['user_id' => $userid];
                $mayknow = R::getAll($queryMayKnow, $paramsMayKnow);
                
                //query for direct friends
                
                
                
                $queryFriends = "SELECT DISTINCT u.id AS userid, u.first_name, u.last_name, u.username, u.photo_url,
                                CASE WHEN f.user_id IS NOT NULL THEN 1 ELSE 0 END AS friendship
                                FROM user u
                                LEFT JOIN friendship f ON u.id = f.friend_id AND f.user_id = :user_id
                                JOIN contact c ON u.id = c.user_id
                                JOIN contactphonenumber cp ON c.id = cp.contact_id
                                WHERE cp.number IN (
                                    SELECT u2.phone_number
                                    FROM user u2
                                    WHERE u2.id = :user_id
                                )
                                AND u.id != :user_id
                                
                                UNION
                                
                                -- Users whose phone number is in the given user's contacts
                                SELECT DISTINCT u3.id AS userid, u3.first_name, u3.last_name, u3.username, u3.photo_url,
                                CASE WHEN f2.user_id IS NOT NULL THEN 1 ELSE 0 END AS friendship
                                FROM user u3
                                LEFT JOIN friendship f2 ON u3.id = f2.friend_id AND f2.user_id = :user_id
                                WHERE EXISTS (
                                    SELECT 1
                                    FROM contact c2
                                    JOIN contactphonenumber cp2 ON c2.id = cp2.contact_id
                                    WHERE cp2.number = u3.phone_number AND c2.user_id = :user_id
                                )
                                AND u3.id != :user_id;";
                                
                                /*
                                $queryFriends = "SELECT DISTINCT u.id AS userid, u.first_name, u.last_name, u.username, u.photo_url
                                FROM user u
                                JOIN contact c ON u.id = c.user_id
                                JOIN contactphonenumber cp ON c.id = cp.contact_id
                                WHERE cp.number IN (
                                    SELECT u2.phone_number
                                    FROM user u2
                                    WHERE u2.id = :user_id
                                )
                                AND u.id != :user_id
                                
                                UNION
                                
                                -- Users whose phone number is in the given user's contacts
                                SELECT DISTINCT u3.id AS userid, u3.first_name, u3.last_name, u3.username, u3.photo_url
                                FROM user u3
                                WHERE EXISTS (
                                    SELECT 1
                                    FROM contact c2
                                    JOIN contactphonenumber cp2 ON c2.id = cp2.contact_id
                                    WHERE cp2.number = u3.phone_number AND c2.user_id = :user_id
                                )
                                AND u3.id != :user_id;";
                                */

                
                $paramsFriends = ['user_id' => $userid];
                $friends = R::getAll($queryFriends, $paramsFriends);
                
                
                //query for school mates
                /*$queryFromSchool = "SELECT u.id AS userid, u.first_name, u.last_name, u.username, u.photo_url,
                    CASE WHEN f.user_id IS NOT NULL THEN 1 ELSE 0 END AS friendship
                    FROM user u
                    LEFT JOIN friendship f ON u.id = f.friend_id AND f.user_id = :user_id
                    WHERE u.school_id = (SELECT school_id FROM user WHERE id = :user_id)
                    AND u.id != :user_id
                    AND NOT EXISTS (
                        SELECT 1 FROM contact c
                        JOIN contactphonenumber cp ON c.id = cp.contact_id
                        WHERE cp.number = u.phone_number AND c.user_id = :user_id
                    );";*/
                    
                    $queryFromSchool = "SELECT u.id AS userid, u.first_name, u.last_name, u.username, u.photo_url,
                    CASE WHEN f.user_id IS NOT NULL THEN 1 ELSE 0 END AS friendship,
                    u.grade
                    FROM user u
                    LEFT JOIN friendship f ON u.id = f.friend_id AND f.user_id = :user_id
                    WHERE u.school_id = (SELECT school_id FROM user WHERE id = :user_id)
                    AND u.id != :user_id
                    AND NOT EXISTS (
                        SELECT 1 FROM contact c
                        JOIN contactphonenumber cp ON c.id = cp.contact_id
                        WHERE cp.number = u.phone_number AND c.user_id = :user_id
                    )
                    ORDER BY (u.grade = (SELECT grade FROM user WHERE id = :user_id)) DESC, u.grade ASC;";

                
                $paramsSchool = ['user_id' => $userid];
                $fromSchool = R::getAll($queryFromSchool, $paramsSchool);

                
                $retobj->mayknow = $mayknow;
                $retobj->friends = $friends;
                $retobj->schoolmates = $fromSchool;
                      
                return $retobj;
            } catch (Exception $e) {
 
            AppLogger::logError("[friendsuggestions]: Error fetching friend suggestions " . $e->getMessage(), [
                'firebaseuserid' => $firebaseuserid
            ]);
            throw new RestException(500, "An error occurred while processing the request.");
        }
    }

}
?>