<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class friend {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function post($friend_ids, $action = 'create'){
        $firebaseuserid = BasicAuth::getfirebaseuserid();
        $userid = BasicAuth::getuserid();
        $user = BasicAuth::getuser();
        
        if (!is_array($friend_ids)) {
            $friend_ids = [$friend_ids]; // Ensure $friend_ids is always an array
        }
    
        $responses = [];
    
        R::begin();
        try {
            foreach ($friend_ids as $friend_id) {
                if ($userid == $friend_id) {
                    // Skip processing for the user's own ID and note it in the responses without affecting overall success
                    $responses[] = ['friend_id' => $friend_id, 'status' => 'skipped', 'message' => 'You cannot friend yourself'];
                    continue;
                }
                $friendship = R::findOne('friendship', 'user_id = ? AND friend_id = ?', [$userid, $friend_id]);
                
                switch ($action) {
                    case 'create':
                        if ($friendship) {
                            $responses[] = ['friend_id' => $friend_id, 'status' => 'exists', 'message' => 'Friendship already exists'];
                        } else {
                            $newFriendship = R::dispense('friendship');
                            $newFriendship->user_id = $userid;
                            $newFriendship->friend_id = $friend_id;
                            R::store($newFriendship);
                            
                            $friend = R::load('user', $friend_id);
                            if($friend->id && $friend->fcm_token != null){
                                $notification_type = 2; //friend added
                               if($friend->reduce_notifications == 1){
                                    $queuenotification = R::dispense('pushnotificationqueue');
                                    $queuenotification->user_id = $friend->id;
                                    $queuenotification->friend_id = $user->id;
                                    $queuenotification->notification_type = $notification_type;
                                    $queuenotification->processed = 0;
                                    R::store($queuenotification);
                                }
                                else{
                                    $title = "$friend->first_name $friend->last_name added you as a friend 🙂";
                                    $body = "Tap here to vote for them!";
                                    sendPushNotification($friend->fcmtoken, $title, $body, SERVICES_ACCOUNT);
                                }
                            }
                            
                                            
                            $responses[] = ['friend_id' => $friend_id, 'status' => 'success', 'message' => 'Friendship created', 'friendship' => $newFriendship];
                        }
                        break;
    
                    case 'delete':
                        if ($friendship) {
                            R::trash($friendship);
                            $responses[] = ['friend_id' => $friend_id, 'status' => 'success', 'message' => 'Friendship deleted'];
                        } else {
                            $responses[] = ['friend_id' => $friend_id, 'status' => 'not found', 'message' => 'No friendship exists to delete'];
                        }
                        break;
    
                    default:
                        $responses[] = ['friend_id' => $friend_id, 'status' => 'error', 'message' => 'Unsupported action'];
                        break;
                }
            }
    
            R::commit();
            return ['status' => 'success', 'responses' => $responses];
            
        } catch (Exception $e) {
            R::rollback();
            AppLogger::logError("[friend]: Error updating friendship(s): " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid, 'action' => $action]);
            return ['status' => 'error', 'message' => 'Transaction failed: ' . $e->getMessage()];
        }
    }


   /* protected function post($friend_id, $action = 'create'){
        $userid = BasicAuth::getUserId();
    
     if($userid == $friend_id){
             return ['status' => 'error', 'message' => 'You cannot friend yourself'];
        }
        // Look for an existing friendship specifically from user_id to friend_id
        $friendship = R::findOne('friendship', 'user_id = ? AND friend_id = ?', [$userid, $friend_id]);
        
            switch ($action) {
                case 'create':
                    if ($friendship) {
                        // Friendship already exists in the specified direction, no need to create a new one
                        return ['status' => 'exists', 'friendship' => $friendship];
                    } else {
                        // Create new friendship
                        $newFriendship = R::dispense('friendship');
                        $newFriendship->user_id = $userid;
                        $newFriendship->friend_id = $friend_id;
                        R::store($newFriendship);
                        
                        return ['status' => 'created', 'friendship' => $newFriendship];
                    }
                    break;
        
                case 'delete':
                    if ($friendship) {
                        // Delete the existing friendship
                        R::trash($friendship);
                        return ['status' => 'deleted'];
                    } else {
                        // No friendship exists in the specified direction to delete
                        return ['status' => 'not found'];
                    }
                    break;
        
                default:
                    // Return an error if an unsupported action is requested
                    return ['status' => 'error', 'message' => 'Unsupported action'];
            }

    }*/
    
    protected function get() {
    	
     try {	
                $firebaseuserid = BasicAuth::getfirebaseuserid();
                $userid = BasicAuth::getuserid();
                $user = BasicAuth::getuser();
                
                // SQL to select friend details from the user table based on friendships
                $sql = "SELECT u.id, u.username, u.first_name, u.last_name, u.grade, u.photo_url, u.gender_id
                        FROM user u
                        JOIN friendship f ON f.friend_id = u.id
                        WHERE f.user_id = ?";
            
                $friends = R::getAll($sql, [$userid]);
            
                $result = new stdClass();
                $result->friends = array();
            
                foreach ($friends as $friend) {
                    // You could also directly assign $friend to $result->friends[] if no further processing is required
                    $friendObj = new stdClass();
                    $friendObj->id = $friend['id'];
                    $friendObj->first_name = $friend['first_name'];
                    $friendObj->last_name = $friend['last_name'];
                    $friendObj->grade = $friend['grade'];
                    $friendObj->gender_id = $friend['gender_id'];
                    $friendObj->photo_url = $friend['photo_url'];
            
                    $result->friends[] = $friendObj;
                }
        
            return $result;
        } 
        catch (Exception $e) {
            AppLogger::logError("[friend] Error fetching friend list: " . $e->getMessage(), [
                'firebaseuserid' => $firebaseuserid
            ]);
            
            throw new RestException(500, "An error occurred while fetching friend list.");
        }
    }
}
?>