<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class createaccount {
    //public $db;
    function __construct() {

    }
    protected function delete($firebaseuserid) {
       if (!$firebaseuserid) {
        throw new RestException(400, 'Error: Firebaseuserid is required to delete an account.');
        }
    
        $retobj = new stdClass();
        
        try {
            $user = R::findOne('user', 'firebaseuserid = ?', [$firebaseuserid]);
    
            if ($user) {
                R::trash($user);
                $retobj->status = "success";
                $retobj->firebaseuserid = $user->firebaseuserid;
            } else {
                $retobj->error = "Error finding user record";
                $retobj->status = "fail";
                AppLogger::logError("[createaccount]: Error finding user record: ", ['firebaseuserid' => $firebaseuserid, 'action' => 'delete']);

            }
        } catch (Exception $e) {
            $retobj->error = "Error deleting user record: " . $e->getMessage();
            $retobj->status = "fail";
            AppLogger::logError("[createaccount]: Error deleting user record: " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid, 'action' => 'delete']);
        }
    
        return $retobj;
    }
        
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    function importContacts($contacts, $userid){
        $preSignedUrls = [];
        $existingContacts = R::count('contact', 'user_id = ?', [$userid]);
        if ($existingContacts > 0) {
            return [
                'success' => true,
                'preSignedUrls' => $preSignedUrls,
                'message' => "User already has contacts. No new contacts were added."
            ];
        }
        
        $successCount = 0;
        $failures = [];
       
        foreach ($contacts as $index => $c) {
            try {
                // Insert into Contact table
                $contactBean = R::dispense('contact');
                
                if (!empty($c['unique_id'])) {
                    $uniqueId = $c['unique_id'];
                    $photoFileName = $uniqueId . '_contact_profile_photo.jpg'; 
    
                    $metadata = [];
                    $preSignedUrl = generateUploadPresignedURL(CLOUDFLARE_R2_PROFILE_IMAGES_BUCKET, $photoFileName, "+20 minutes", $metadata);
                   
                    $preSignedUrls[$uniqueId] = $preSignedUrl;
                    $contactBean->photo_url = $photoFileName;
                }
                
                $contactBean->first_name = $c['first_name'];
                $contactBean->last_name = $c['last_name'];
                $contactBean->user_id = $userid; 
                $contactBean->created_at = gmdate('Y-m-d H:i:s');
                $contactBean->updated_at = gmdate('Y-m-d H:i:s');
                $contactId = R::store($contactBean);
                
                // Insert phone numbers
                foreach ($c['phone_numbers'] as $phone) {
                    $phoneBean = R::dispense('contactphonenumber');
                    $phoneBean->type = $phone['type'];
                    $phoneBean->number = $phone['number'];
                    $phoneBean->contact_id = $contactId;
                    $phoneBean->created_at = gmdate('Y-m-d H:i:s');
                    $phoneBean->updated_at = gmdate('Y-m-d H:i:s');
                    R::store($phoneBean);
                }
    
                // Insert emails
                foreach ($c['emails'] as $email) {
                    $emailBean = R::dispense('contactemail');
                    $emailBean->email = $email['email'];
                    $emailBean->contact_id = $contactId;
                    $emailBean->created_at = gmdate('Y-m-d H:i:s');
                    $emailBean->updated_at = gmdate('Y-m-d H:i:s');
                    R::store($emailBean);
                }
    
                $successCount++;
            } catch (Exception $e) {
        
                AppLogger::logError("[contact]: Error importing contacts: " . $e->getMessage(), []);
                
                return [
                    'success' => false,
                    'preSignedUrls' => [],
                    'message' => "Error processing contacts"
                ];
            }
        }
    
        return [
            'success' => true,
            'preSignedUrls' => $preSignedUrls,
            'message' => "Contacts processed. Successes: $successCount"
        ];
    }


	function post($firebaseuserid, $contacts, $phonenumber, $grade, $schoolid, $age, $classyear="1979"){
	    
		if (!$firebaseuserid) {
			throw new RestException(400, 'Error: Firebaseuserid is required to create an account.');
		}
		
		if (!$contacts) {
			throw new RestException(400, 'Error: contacts are required to create an account.');
		}
		
		if (!$phonenumber) {
			throw new RestException(400, 'Error: Phone number is required to create an account.');
		}
		
		if (!$grade) {
			throw new RestException(400, 'Error: Grade is required to create an account.');
		}
		
		if (!$schoolid) {
			throw new RestException(400, 'Error: School is required to create an account.');
		}
		
		if (!$age) {
			throw new RestException(400, 'Error: Age is required to create an account.');
		}

    	$retobj = new stdClass();
        try {
            R::begin();
            // First, try to find an existing user with the given firebaseuserid
            $existingUser = R::findOne('user', 'firebaseuserid = ?', [$firebaseuserid]);
        
            if (!$existingUser) {
                // No existing user found, so create a new one
                $user = R::dispense('user');
                $user->firebaseuserid = $firebaseuserid;
                $user->phone_number = $phonenumber;
                $user->school_id = $schoolid;
                $user->grade = $grade;
                $user->initial_grade = $grade;
                $user->grade_entry_date = gmdate('Y-m-d');
                $user->expected_graduation_year = $classyear;
                $user->age = $age;
                //$user->api_token = generateUUIDv4();
                $userid = R::store($user);
                $user = R::load('user', $userid);
                $retobj->userid = $userid;
                
                //on account creation we insert a new inbox message
                //from Team YAAAS to welcome the the user!
                $inbox = R::dispense('inbox');
                $inbox->user_id = $userid;
                $inbox->friend_id = 1;
                $inbox->grade = 12;
                $inbox->gender_id = 2;
                $inbox->response_id = 1;
                R::store($inbox);
                
                $retobj->new_user = true;
            } else {
                $user = $existingUser;
                $user->phone_number = $phonenumber;
                $user->school_id = $schoolid;
                $user->grade = $grade;
                $user->initial_grade = $grade;
                $user->grade_entry_date = gmdate('Y-m-d');
                $user->expected_graduation_year = $classyear;
                $user->age = $age;
                $userid = R::store($user);
                $user = R::load('user', $userid);
                $retobj->userid = $userid;
                $retobj->gender_id = $user->gender_id;
                $retobj->new_user = false;
            }
        
            // Populate return object with user information
            $retobj->firebaseuserid = $user->firebaseuserid;
            $retobj->phone_number = $user->phone_number;
            $retobj->api_token = $user->api_token;
            $retobj->resource_token = $user->resource_token;
            
            $contactResponse = $this->importContacts($contacts, $userid);
            
            $success = $contactResponse['success'];
            $preSignedUrls = $contactResponse['preSignedUrls'];
            $message = $contactResponse['message'];
            
            if ($success) {
                $retobj->preSignedUrls = $preSignedUrls;
            }
            else {
                 AppLogger::logError("[createaccount]: Error could not create new account: could not import contacts!", ['firebaseuserid' => $firebaseuserid, 'action' => 'create']);
            
                throw new RestException(400, 'Error: Could not create new account: could not import contacts!');
            }
            
            R::commit();
            
        } catch (Exception $e) {
            R::rollback();
            AppLogger::logError("[createaccount]: Error could not create new account: " . $e->getMessage(), ['firebaseuserid' => $firebaseuserid, 'action' => 'create']);
            
            throw new RestException(400, 'Error: Could not create new account: '. $e->getMessage());
        }
        
        return $retobj;
    }
	
    
	function get($phone_number) {
	    if (!$phone_number) {
			throw new RestException(400, 'Error: phone number is required.');
		}
		
		$phone_number = trim($phone_number);
        if ($phone_number[0] !== '+') {
            $phone_number = "+" . $phone_number;
        }

        $eval = "SELECT * FROM user from phone_number = $phone_number";
		$user = R::findOne('user', ' phone_number = ? ', [$phone_number]);
		$status = "fail";
		if($user){
		    $status = "success";
		}
		else{
		    $status = "fail";
		}
		return ["status" => $status, "phone" => $phone_number, "eval" => $eval];
	}
    
}
?>