<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class cashout {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($name, $version) {
        throw new RestException(501, 'PUT not implemented');
    }
    
    protected function findLatestUserPollByUserId($userId) {
        try {
            return R::findOne('userpoll', ' user_id = ? ORDER BY poll_id DESC LIMIT 1', [$userId]);
        } catch (Exception $e) {
             AppLogger::logError("[cashout]: Error finding latest user poll: " . $e->getMessage(), [
                    'userid' => $userId
                ]);
            throw new RestException(500, "Error finding latest user poll.");
        }
    }
    
    protected function post(){
        try {
            $userid = BasicAuth::getuserid();
            $latestUserPoll = $this->findLatestUserPollByUserId($userid);
    
            if (!$latestUserPoll) {
                return ['status' => 'error', 'message' => "User poll not found."];
            }
    
            if (!$latestUserPoll->completed) {
                return ['status' => 'fail', 'message' => "Poll not completed yet."];
            }
    
            if ($latestUserPoll->cashedout) {
                return ['status' => 'fail', 'message' => "Already cashed out."];
            }
    
            R::begin();
            try {
                $user = BasicAuth::getuser();
                
                if (subscriptionIsActive($user->id)) {
                    $user->coins += 2 * $latestUserPoll->coins_earned; // Double coins if subscription is active
                } else {
                    $user->coins += $latestUserPoll->coins_earned; // Regular coins if subscription is not active
                }
                
                $latestUserPoll->cashedout = 1;
                
                R::store($user);
                R::store($latestUserPoll);
                
                R::commit();
            } catch (Exception $e) {
                R::rollback();
    
                return ['status' => 'error', 'message' => "Failed to update user and poll records."];
            }
    
            return ['status' => 'success', 'message' => "Coins updated successfully."];
        } catch (Exception $e) {
            return ['status' => 'error', 'message' => "An error occurred."]; 
        }
    }
    
    function get(){
        	$retobj = new stdClass();
        	$retobj->status =  "success";
        	$retobj->responses =  "test";
        	return $retobj;
         return ['status' => 'success', 'responses' => "test"];
    }
 
}
?>