<?php
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class BasicAuth implements iAuthenticate {
    const REALM = 'Restricted API';
    private static $userid;
    private static $g_user;
    private static $g_firebaseuserid;
    private static $g_apitoken;
	
	private static function __sendUnauthorized($message) {
        header('WWW-Authenticate: Bearer realm="' . self::REALM . '"');
        header('HTTP/1.0 401 Unauthorized');
        throw new RestException(401, $message);
    }

    public function __isAuthenticated() {
        $headers = getallheaders();

        if (!isset($headers['Authorization'])) {
            self::__sendUnauthorized('Bearer Token Not Found');
        }

        if (preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
            $idTokenString = $matches[1];
            $user = R::findOne('user', 'firebaseuserid = ?', [$idTokenString]);

            if ($user) {
                self::$userid = $user->id;
                self::$g_apitoken = $user->api_token;
                self::$g_user = $user;
				self::$g_firebaseuserid = $user->firebaseuserid;
                return true;
            }
        }

        self::__sendUnauthorized('Bearer Token Authentication Required');
    }
    
    public static function getapitoken() {
        return self::$g_apitoken;
    }
    
    public static function getfirebaseuserid() {
        return self::$g_firebaseuserid;
    }
    
    public static function getuserid() {
        return self::$userid;
    }
    
    public static function getuser() {
        return self::$g_user;
    }
}
?>