<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once ('../libs/rb.php');
require_once ('../libs/db.php');
require_once ('../libs/common.php');

class activity {
    //public $db;
    function __construct() {

    }
    protected function delete($id, $name, $data, $tag) {
        throw new RestException(501, 'DELETE not implemented');
    }
    
    protected function put($response_id, $hide=1) {
       $user = BasicAuth::getuser();
       
       if(!$response_id) {
            throw new RestException(400, 'response_id must be supplied');
       }
       
       try{
           $retobj = new stdClass();
           $response = R::findOne('response', ' id = ? AND selected_friend_id = ? ', [$response_id, $user->id]);
           if($response) {
               
               $response->hide_activity_feed = ($hide == 1) ? 1 : 0;
               R::store($response);
               
               $retobj->status =  "success";
               $retobj->message = $hide == 1 ? "hidden" : "visible";
           }
           else {
               $retobj->status =  "error";
               $retobj->message = "Could not find response to hide";
           }
           
       } catch (Exception $e) {
          
          return ['status' => 'error', 'message' => "Failed to update response record."];
       }
    	return $retobj;
    }
    
    function post(){
        throw new RestException(501, 'POST not implemented');
    }
    
    protected function get(){
        $user = BasicAuth::getuser();
        
        $sql = "SELECT 
            response.*, 
            gender.slang AS gender_slang,
            gender.gender AS gender_name,
            user.first_name AS friend_first_name, 
            user.photo_url AS friend_photo_url,
            user.last_name AS friend_last_name,
            question.text AS question_text,
            question.emoji AS question_emoji
        FROM 
            response 
        JOIN 
            friendship ON response.selected_friend_id = friendship.friend_id AND friendship.user_id = :userid 
        JOIN 
            user ON response.selected_friend_id = user.id 
        JOIN 
            gender ON user.gender_id = gender.id
        JOIN 
            question ON response.question_id = question.id 
        WHERE response.hide_activity_feed = 0
        ORDER BY 
            response.id DESC 
        LIMIT 20";
        
        $responses = R::getAll($sql, [':userid' => $user->id]);
        
        //$responses = R::find('response', ' selected_friend_id IN (SELECT friend_id FROM friendship WHERE user_id = :userid) ORDER BY created_at DESC LIMIT 20 ', [':userid' => $user->id]);
        
    	$retobj = new stdClass();
    	$retobj->status =  "success";
    	$retobj->responses = $responses;
    	return $retobj;
    }
}
?>