<?php
 class Zend_Amf_Util_BinaryStream { protected $_stream; protected $_streamLength; protected $_bigEndian; protected $_needle; public function __construct($stream) { if (!is_string($stream)) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Inputdata is not of type String'); } $this->_stream = $stream; $this->_needle = 0; $this->_streamLength = strlen($stream); $this->_bigEndian = (pack('l', 1) === "\x00\x00\x00\x01"); } public function getStream() { return $this->_stream; } public function readBytes($length) { if (($length + $this->_needle) > $this->_streamLength) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Buffer underrun at needle position: ' . $this->_needle . ' while requesting length: ' . $length); } $bytes = substr($this->_stream, $this->_needle, $length); $this->_needle+= $length; return $bytes; } public function writeBytes($bytes) { $this->_stream.= $bytes; return $this; } public function readByte() { if (($this->_needle + 1) > $this->_streamLength) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Buffer underrun at needle position: ' . $this->_needle . ' while requesting length: ' . $length); } return ord($this->_stream{$this->_needle++}); } public function writeByte($stream) { $this->_stream.= pack('c', $stream); return $this; } public function readInt() { return ($this->readByte() << 8) + $this->readByte(); } public function writeInt($stream) { $this->_stream.= pack('n', $stream); return $this; } public function readUtf() { $length = $this->readInt(); return $this->readBytes($length); } public function writeUtf($stream) { $this->writeInt(strlen($stream)); $this->_stream.= $stream; return $this; } public function readLongUtf() { $length = $this->readLong(); return $this->readBytes($length); } public function writeLongUtf($stream) { $this->writeLong(strlen($stream)); $this->_stream.= $stream; } public function readLong() { return ($this->readByte() << 24) + ($this->readByte() << 16) + ($this->readByte() << 8) + $this->readByte(); } public function writeLong($stream) { $this->_stream.= pack('N', $stream); return $this; } public function readUnsignedShort() { $byte1 = $this->readByte(); $byte2 = $this->readByte(); return (($byte1 << 8) | $byte2); } public function readDouble() { $bytes = substr($this->_stream, $this->_needle, 8); $this->_needle+= 8; if (!$this->_bigEndian) { $bytes = strrev($bytes); } $double = unpack('dflt', $bytes); return $double['flt']; } public function writeDouble($stream) { $stream = pack('d', $stream); if (!$this->_bigEndian) { $stream = strrev($stream); } $this->_stream.= $stream; return $this; } } 