<?php
 require_once 'Zend/Amf/Constants.php'; require_once 'Zend/Amf/Parse/Serializer.php'; require_once 'Zend/Amf/Parse/TypeLoader.php'; class Zend_Amf_Parse_Amf3_Serializer extends Zend_Amf_Parse_Serializer { protected $_referenceObjects = array(); protected $_referenceStrings = array(); protected $_referenceDefinitions = array(); public function writeTypeMarker($data, $markerType=null) { if (null !== $markerType) { $this->_stream->writeByte($markerType); switch ($markerType) { case Zend_Amf_Constants::AMF3_NULL: break; case Zend_Amf_Constants::AMF3_BOOLEAN_FALSE: break; case Zend_Amf_Constants::AMF3_BOOLEAN_TRUE: break; case Zend_Amf_Constants::AMF3_INTEGER: $this->writeInteger($data); break; case Zend_Amf_Constants::AMF3_NUMBER: $this->_stream->writeDouble($data); break; case Zend_Amf_Constants::AMF3_STRING: $this->writeString($data); break; case Zend_Amf_Constants::AMF3_DATE: $this->writeDate($data); break; case Zend_Amf_Constants::AMF3_ARRAY: $this->writeArray($data); break; case Zend_Amf_Constants::AMF3_OBJECT: $this->writeObject($data); break; case Zend_Amf_Constants::AMF3_BYTEARRAY: $this->writeByteArray($data); break; case Zend_Amf_Constants::AMF3_XMLSTRING; $this->writeXml($data); break; default: require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unknown Type Marker: ' . $markerType); } } else { if(is_resource($data)) { $data = Zend_Amf_Parse_TypeLoader::handleResource($data); } switch (true) { case (null === $data): $markerType = Zend_Amf_Constants::AMF3_NULL; break; case (is_bool($data)): if ($data){ $markerType = Zend_Amf_Constants::AMF3_BOOLEAN_TRUE; } else { $markerType = Zend_Amf_Constants::AMF3_BOOLEAN_FALSE; } break; case (is_int($data)): if (($data > 0xFFFFFFF) || ($data < -268435456)) { $markerType = Zend_Amf_Constants::AMF3_NUMBER; } else { $markerType = Zend_Amf_Constants::AMF3_INTEGER; } break; case (is_float($data)): $markerType = Zend_Amf_Constants::AMF3_NUMBER; break; case (is_string($data)): $markerType = Zend_Amf_Constants::AMF3_STRING; break; case (is_array($data)): $markerType = Zend_Amf_Constants::AMF3_ARRAY; break; case (is_object($data)): if (($data instanceof DateTime) || ($data instanceof Zend_Date)) { $markerType = Zend_Amf_Constants::AMF3_DATE; } else if ($data instanceof Zend_Amf_Value_ByteArray) { $markerType = Zend_Amf_Constants::AMF3_BYTEARRAY; } else if (($data instanceof DOMDocument) || ($data instanceof SimpleXMLElement)) { $markerType = Zend_Amf_Constants::AMF3_XMLSTRING; } else { $markerType = Zend_Amf_Constants::AMF3_OBJECT; } break; default: require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unsupported data type: ' . gettype($data)); } $this->writeTypeMarker($data, $markerType); } } public function writeInteger($int) { if (($int & 0xffffff80) == 0) { $this->_stream->writeByte($int & 0x7f); return $this; } if (($int & 0xffffc000) == 0 ) { $this->_stream->writeByte(($int >> 7 ) | 0x80); $this->_stream->writeByte($int & 0x7f); return $this; } if (($int & 0xffe00000) == 0) { $this->_stream->writeByte(($int >> 14 ) | 0x80); $this->_stream->writeByte(($int >> 7 ) | 0x80); $this->_stream->writeByte($int & 0x7f); return $this; } $this->_stream->writeByte(($int >> 22 ) | 0x80); $this->_stream->writeByte(($int >> 15 ) | 0x80); $this->_stream->writeByte(($int >> 8 ) | 0x80); $this->_stream->writeByte($int & 0xff); return $this; } protected function writeBinaryString($string){ $ref = strlen($string) << 1 | 0x01; $this->writeInteger($ref); $this->_stream->writeBytes($string); return $this; } public function writeString($string) { $len = strlen($string); if(!$len){ $this->writeInteger(0x01); return $this; } $ref = array_search($string, $this->_referenceStrings, true); if($ref === false){ $this->_referenceStrings[] = $string; $this->writeBinaryString($string); } else { $ref <<= 1; $this->writeInteger($ref); } return $this; } public function writeByteArray($data){ if($this->writeObjectReference($data)){ return $this; } if(is_string($data)) { } else if ($data instanceof Zend_Amf_Value_ByteArray) { $data = $data->getData(); } else { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Invalid ByteArray specified; must be a string or Zend_Amf_Value_ByteArray'); } $this->writeBinaryString($data); return $this; } public function writeXml($xml) { if($this->writeObjectReference($xml)){ return $this; } if(is_string($xml)) { } else if ($xml instanceof DOMDocument) { $xml = $xml->saveXml(); } else if ($xml instanceof SimpleXMLElement) { $xml = $xml->asXML(); } else { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Invalid xml specified; must be a DOMDocument or SimpleXMLElement'); } $this->writeBinaryString($xml); return $this; } public function writeDate($date) { if($this->writeObjectReference($date)){ return $this; } if ($date instanceof DateTime) { $dateString = $date->format('U') * 1000; } elseif ($date instanceof Zend_Date) { $dateString = $date->toString('U') * 1000; } else { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Invalid date specified; must be a string DateTime or Zend_Date object'); } $this->writeInteger(0x01); $this->_stream->writeDouble($dateString); return $this; } public function writeArray(array $array) { $this->_referenceObjects[] = $array; $numeric = array(); $string = array(); foreach ($array as $key => $value) { if (is_int($key)) { $numeric[] = $value; } else { $string[$key] = $value; } } $length = count($numeric); $id = ($length << 1) | 0x01; $this->writeInteger($id); foreach($string as $key => $value) { $this->writeString($key) ->writeTypeMarker($value); } $this->writeString(''); foreach($numeric as $value) { $this->writeTypeMarker($value); } return $this; } protected function writeObjectReference($object) { $ref = array_search($object, $this->_referenceObjects,true); if($ref !== false){ $ref <<= 1; $this->writeInteger($ref); return true; } $this->_referenceObjects[] = $object; return false; } public function writeObject($object) { if($this->writeObjectReference($object)){ return $this; } $className = ''; switch (true) { case ($className = Zend_Amf_Parse_TypeLoader::getMappedClassName(get_class($object))): break; case isset($object->_explicitType): $className = $object->_explicitType; break; case method_exists($object, 'getASClassName'): $className = $object->getASClassName(); break; case ($object instanceof stdClass): $className = ''; break; default: $className = get_class($object); break; } $writeTraits = true; if(array_key_exists($className, $this->_referenceDefinitions)){ $traitsInfo = $this->_referenceDefinitions[$className]['id']; $encoding = $this->_referenceDefinitions[$className]['encoding']; $propertyNames = $this->_referenceDefinitions[$className]['propertyNames']; $traitsInfo = ($traitsInfo << 2) | 0x01; $writeTraits = false; } else { $propertyNames = array(); if($className == ''){ $encoding = Zend_Amf_Constants::ET_DYNAMIC; } else { $encoding = Zend_Amf_Constants::ET_PROPLIST; foreach($object as $key => $value) { if( $key[0] != "_") { $propertyNames[] = $key; } } } $this->_referenceDefinitions[$className] = array( 'id' => count($this->_referenceDefinitions), 'encoding' => $encoding, 'propertyNames' => $propertyNames, ); $traitsInfo = Zend_Amf_Constants::AMF3_OBJECT_ENCODING; $traitsInfo |= $encoding << 2; $traitsInfo |= (count($propertyNames) << 4); } $this->writeInteger($traitsInfo); if($writeTraits){ $this->writeString($className); foreach ($propertyNames as $value) { $this->writeString($value); } } try { switch($encoding) { case Zend_Amf_Constants::ET_PROPLIST: foreach ($propertyNames as $key) { $this->writeTypeMarker($object->$key); } break; case Zend_Amf_Constants::ET_DYNAMIC: foreach ($propertyNames as $key) { $this->writeTypeMarker($object->$key); } foreach($object as $key => $value){ if(!in_array($key,$propertyNames) && $key[0] != "_"){ $this->writeString($key); $this->writeTypeMarker($value); } } $this->writeString(''); break; case Zend_Amf_Constants::ET_EXTERNAL: require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('External Object Encoding not implemented'); break; default: require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unknown Object Encoding type: ' . $encoding); } } catch (Exception $e) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unable to writeObject output: ' . $e->getMessage(), 0, $e); } return $this; } } 