<?php
 require_once 'Zend/Amf/Constants.php'; require_once 'Zend/Amf/Parse/Deserializer.php'; require_once 'Zend/Amf/Parse/TypeLoader.php'; class Zend_Amf_Parse_Amf3_Deserializer extends Zend_Amf_Parse_Deserializer { protected $_objectCount; protected $_referenceObjects = array(); protected $_referenceStrings = array(); protected $_referenceDefinitions = array(); public function readTypeMarker($typeMarker = null) { if(null === $typeMarker) { $typeMarker = $this->_stream->readByte(); } switch($typeMarker) { case Zend_Amf_Constants::AMF3_UNDEFINED: return null; case Zend_Amf_Constants::AMF3_NULL: return null; case Zend_Amf_Constants::AMF3_BOOLEAN_FALSE: return false; case Zend_Amf_Constants::AMF3_BOOLEAN_TRUE: return true; case Zend_Amf_Constants::AMF3_INTEGER: return $this->readInteger(); case Zend_Amf_Constants::AMF3_NUMBER: return $this->_stream->readDouble(); case Zend_Amf_Constants::AMF3_STRING: return $this->readString(); case Zend_Amf_Constants::AMF3_DATE: return $this->readDate(); case Zend_Amf_Constants::AMF3_ARRAY: return $this->readArray(); case Zend_Amf_Constants::AMF3_OBJECT: return $this->readObject(); case Zend_Amf_Constants::AMF3_XML: case Zend_Amf_Constants::AMF3_XMLSTRING: return $this->readXmlString(); case Zend_Amf_Constants::AMF3_BYTEARRAY: return $this->readString(); default: require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unsupported type marker: ' . $typeMarker); } } public function readInteger() { $count = 1; $intReference = $this->_stream->readByte(); $result = 0; while ((($intReference & 0x80) != 0) && $count < 4) { $result <<= 7; $result |= ($intReference & 0x7f); $intReference = $this->_stream->readByte(); $count++; } if ($count < 4) { $result <<= 7; $result |= $intReference; } else { $result <<= 8; $result |= $intReference; if (($result & 0x10000000) != 0) { $result |= ~0xFFFFFFF; } } return $result; } public function readString() { $stringReference = $this->readInteger(); if (($stringReference & 0x01) == 0) { $stringReference = $stringReference >> 1; if ($stringReference >= count($this->_referenceStrings)) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Undefined string reference: ' . $stringReference); } return $this->_referenceStrings[$stringReference]; } $length = $stringReference >> 1; if ($length) { $string = $this->_stream->readBytes($length); $this->_referenceStrings[] = $string; } else { $string = ""; } return $string; } public function readDate() { $dateReference = $this->readInteger(); if (($dateReference & 0x01) == 0) { $dateReference = $dateReference >> 1; if ($dateReference>=count($this->_referenceObjects)) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Undefined date reference: ' . $dateReference); } return $this->_referenceObjects[$dateReference]; } $timestamp = floor($this->_stream->readDouble() / 1000); require_once 'Zend/Date.php'; $dateTime = new Zend_Date((int) $timestamp); $this->_referenceObjects[] = $dateTime; return $dateTime; } public function readArray() { $arrayReference = $this->readInteger(); if (($arrayReference & 0x01)==0){ $arrayReference = $arrayReference >> 1; if ($arrayReference>=count($this->_referenceObjects)) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unknow array reference: ' . $arrayReference); } return $this->_referenceObjects[$arrayReference]; } $data = array(); $this->_referenceObjects[] =& $data; $key = $this->readString(); while ($key != '') { $data[$key] = $this->readTypeMarker(); $key = $this->readString(); } $arrayReference = $arrayReference >>1; for ($i=0; $i < $arrayReference; $i++) { $data[] = $this->readTypeMarker(); } return $data; } public function readObject() { $traitsInfo = $this->readInteger(); $storedObject = ($traitsInfo & 0x01)==0; $traitsInfo = $traitsInfo >> 1; if ($storedObject) { $ref = $traitsInfo; if (!isset($this->_referenceObjects[$ref])) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unknown Object reference: ' . $ref); } $returnObject = $this->_referenceObjects[$ref]; } else { $storedClass = ($traitsInfo & 0x01) == 0; $traitsInfo = $traitsInfo >> 1; if ($storedClass) { $ref = $traitsInfo; if (!isset($this->_referenceDefinitions[$ref])) { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Unknows Definition reference: '. $ref); } $className = $this->_referenceDefinitions[$ref]['className']; $encoding = $this->_referenceDefinitions[$ref]['encoding']; $propertyNames = $this->_referenceDefinitions[$ref]['propertyNames']; } else { $className = $this->readString(); $encoding = $traitsInfo & 0x03; $propertyNames = array(); $traitsInfo = $traitsInfo >> 2; } if (!$className) { $returnObject = new stdClass(); } else { if ($loader = Zend_Amf_Parse_TypeLoader::loadType($className)) { $returnObject = new $loader(); } else { require_once 'Zend/Amf/Exception.php'; throw new Zend_Amf_Exception('Typed object not found: '. $className . ' '); } } $this->_referenceObjects[] = $returnObject; $properties = array(); switch ($encoding) { case (Zend_Amf_Constants::ET_EXTERNAL): if (!$storedClass) { $this->_referenceDefinitions[] = array( 'className' => $className, 'encoding' => $encoding, 'propertyNames' => $propertyNames, ); } $returnObject->externalizedData = $this->readTypeMarker(); break; case (Zend_Amf_Constants::ET_DYNAMIC): if (!$storedClass) { $this->_referenceDefinitions[] = array( 'className' => $className, 'encoding' => $encoding, 'propertyNames' => $propertyNames, ); } do { $property = $this->readString(); if ($property != "") { $propertyNames[] = $property; $properties[$property] = $this->readTypeMarker(); } } while ($property !=""); break; default: if (!$storedClass) { $count = $traitsInfo; for($i=0; $i< $count; $i++) { $propertyNames[] = $this->readString(); } $this->_referenceDefinitions[] = array( 'className' => $className, 'encoding' => $encoding, 'propertyNames' => $propertyNames, ); } foreach ($propertyNames as $property) { $properties[$property] = $this->readTypeMarker(); } break; } foreach($properties as $key=>$value) { if($key) { $returnObject->$key = $value; } } } if($returnObject instanceof Zend_Amf_Value_Messaging_ArrayCollection) { if(isset($returnObject->externalizedData)) { $returnObject = $returnObject->externalizedData; } else { $returnObject = get_object_vars($returnObject); } } return $returnObject; } public function readXmlString() { $xmlReference = $this->readInteger(); $length = $xmlReference >> 1; $string = $this->_stream->readBytes($length); return simplexml_load_string($string); } } 